#!/bin/sh
# getroms.sh for getting the needed ROMS for VICEplus
#
# written by Marco van den Heuvel <blackystardust68@yahoo.com>
#
# getroms.sh <wget> <vice-version> <rom-kind>
#            $1     $2             $3

WGET=$1
VERSION=$2
ROMKIND=$3

site1=http://rickbalkinsbuildingdesign.com/Documents
gzipname1=vice-roms.tgz
dirprefix1=.
size1=351353

vicesite=http://www.viceteam.org/online
vicegzipname=vice-$VERSION.tar.gz
vicedirprefix=vice-$VERSION/data
vicesize=6088483

INSTALL_DONE=no
DOWNLOAD_DONE=no

get_archive()
{
# <url> <gzip-name> <gzip-size>
# $1    $2          $3
  if test x"$WGET" != "xfalse"; then
    if [ ! -e ../$2 ]; then
      if [ x"`basename $WGET`" = "xcurl" ]; then
        (cd .. && $WGET -O $1/$2)
      else
      	$WGET -O ../$2 $1/$2
      fi
      if [ -e ../$2 ]; then
        sizetemp=`wc -c ../$2`
        nameamount=`expr "../$2" : '.*'`
        cutamount=`expr "$sizetemp" : '.*' - 1 - $nameamount`
        SIZE=`wc -c ../$2 | cut -c1-$cutamount`
        if [ $SIZE -le $3 ]; then
          if [ $SIZE -ge $3 ]; then
            DOWNLOAD_DONE=yes
            echo download done
          else
            rm -f ../$2
          fi
        else
          rm -f ../$2
        fi
      fi
    fi
  fi
}

unpack_archive()
{
# <gzip-name> <dir-prefix>
# $1          $2

  currentdir=`pwd`
  cd ..
  echo unpacking $1
  gzip -dc $1 | tar -xf -

  if test x"$2" != "x."; then
    for i in basic64 basichi basiclo chargde chargen chargfr chargse kernal \
             kernal64 kernalde kernalfi kernalfr kernalit kernalno kernalse
    do
      cp $2/C128/$i C128/
    done

    for i in basic chargen kernal
    do
      cp $2/C64/$i C64/
      cp $2/C64/$i C64DTV/
    done

    for i in basic.128 basic.256 basic.500 chargen.500 chargen.600 \
             chargen.700 kernal kernal.500
    do
      cp $2/CBM-II/$i CBM-II/
    done

    for i in dos1541 dos1551 d1541II dos1570 dos1571 d1571cr dos1581 dos2031 \
             dos1001 dos2040 dos3040 dos4040
    do
      cp $2/DRIVES/$i DRIVES/
    done

    for i in basic1 basic2 basic4 kernal1 kernal2 kernal4 edit1g edit2g \
             edit2b edit4g40 edit4b40 edit4b80 chargen chargen.de
    do
      cp $2/PET/$i PET/
    done

    for i in 3plus1hi 3plus1lo basic kernal
    do
      cp $2/PLUS4/$i PLUS4/
    done

    for i in cbm1526 mps801 mps803 nl10-cbm
    do
      cp $2/PRINTER/$i PRINTER/
    done

    for i in basic chargen kernal
    do
      cp $2/VIC20/$i VIC20/
    done

  else
    for i in basic chargen kernal
    do
      cp C64/$i C64DTV/
    done
  fi
  cd $currentdir
  INSTALL_DONE=yes
}

if test x"$ROMKIND" != "xdtv"; then
  if test x"$WGET" = "xfalse"; then
    if [ -e ../$gzipname1 ]; then
      unpack_archive $gzipname1 $dirprefix1
    fi
    if test x"$INSTALL_DONE" = "xno"; then
      if [ -e ../$vicegzipname ]; then
        unpack_archive $vicegzipname $vicedirprefix
      fi
    fi
  else
    if [ ! -e ../$gzipname1 ]; then
      get_archive $site1 $gzipname1 $size1
      if test x"$DOWNLOAD_DONE" = "xyes"; then
        unpack_archive $gzipname1 $dirprefix1
      fi
    fi
    if test x"$INSTALL_DONE" = "xno"; then
      if [ ! -e ../$vicegzipname ]; then
        get_archive $vicesite $vicegzipname $vicesize
        if test x"$DOWNLOAD_DONE" = "xyes"; then
          unpack_archive $vicegzipname $vicedirprefix
        fi
      fi
    fi
  fi

  if test x"$INSTALL_DONE" = "xno"; then
    echo "------------------------------------------------------------------------------"
    echo ROM files were not found, if you have wget installed and you want the ROM
    echo files automatically downloaded then please use the configure argument
    echo --enable-romdownload.
    echo ""
    echo If you do not have wget installed or you do not want the ROM files to be
    echo downloaded automatically then please download vice-$VERSION.tar.gz, and place
    echo it in the data directory of the current build directory.
    echo "------------------------------------------------------------------------------"
    exit 1
  fi
else
  if test x"$WGET" = "xfalse"; then
    if [ ! -e ../dtvrom.bin ]; then
      echo "------------------------------------------------------------------------------"
      echo DTV FLASH ROM download is enabled but wget was not found or the configure
      echo argument --enable-romdownload was not given.
      echo ""
      echo If you do not have wget installed or you do not want the DTV FLASH ROM to be
      echo downloaded automatically then please download dtvrom.bin, and place it in the
      echo data directory of the current build directory.
      echo "------------------------------------------------------------------------------"
      exit 1
    else
      mv ../dtvrom.bin ./
    fi
  else
    if [ ! -e ../dtvrom.bin ]; then
      get_archive http://rickbalkinsbuildingdesign.com/Documents dtvrom.bin 2097152
      if test x"%DOWNLOAD_DONE" = "xno"; then
        echo "------------------------------------------------------------------------------"
        echo dtvrom.bin could not be downloaded
        echo "------------------------------------------------------------------------------"
      else
        mv ../dtvrom.bin ./
      fi
    fi
  fi
fi
