#!/bin/sh
# make-bindist.sh for the AmigaOS ports
#
# written by Marco van den Heuvel <blackystardust68@yahoo.com>
#
# make-bindist.sh <strip> <vice-version> <dtv-name> <dtv-revision> <host-cpu> <host-system> <zip|nozip> <top-srcdir> <release> <release-number> <exe-ext>
#                 $1      $2             $3         $4             $5         $6             $7          $8          $9        $10              $11

STRIP=$1
VICE_VERSION=$2
DTV_NAME=$3
DTV_REVISION=$4
HOST_CPU=$5
HOST_SYSTEM=$6
ZIPKIND=$7
TOP_SRC_DIR=$8
RELEASE=$9

shift
RELEASE_NUMBER=$9

shift
EXE_EXT=$9


if [ ! -e src/x64$EXE_EXT -o ! -e src/x64dtv$EXE_EXT -o ! -e src/x128$EXE_EXT -o ! -e src/xvic$EXE_EXT -o ! -e src/xpet$EXE_EXT -o ! -e src/xplus4$EXE_EXT -o ! -e src/xcbm2$EXE_EXT -o ! -e src/c1541$EXE_EXT -o ! -e src/petcat$EXE_EXT -o ! -e src/cartconv$EXE_EXT ]
then
  echo Error: executable file\(s\) not found, do a \"make\" first
  exit 1
fi

if test x"$HOST_SYSTEM" = "xaros"; then
  if test x"$RELEASE" = "xyes"; then
    AMIGAFLAVOR=$HOST_CPU-AROS-$RELEASE_NUMBER-$VICE_VERSION
  else
    AMIGAFLAVOR=$HOST_CPU-AROS-$VICE_VERSION-$DTV_REVISION
  fi
  echo Generating AROS port binary distribution.
else
  if test x"$HOST_SYSTEM" = "xmorphos"; then
    if test x"$RELEASE" = "xyes"; then
      AMIGAFLAVOR=MorphOS-$RELEASE_NUMBER-$VICE_VERSION
    else
      AMIGAFLAVOR=MorphOS-$VICE_VERSION-$DTV_REVISION
    fi
    echo Generating MorphOS port binary distribution.
  else
    if test x"$HOST_SYSTEM" = "xwarpos"; then
      if test x"$RELEASE" = "xyes"; then
        AMIGAFLAVOR=WarpOS-$RELEASE_NUMBER-$VICE_VERSION
      else
        AMIGAFLAVOR=WarpOS-$VICE_VERSION-$DTV_REVISION
      fi
      echo Generating WarpOS port binary distribution.
    else
      if test x"$HOST_SYSTEM" = "xpowerup"; then
        if test x"$RELEASE" = "xyes"; then
          AMIGAFLAVOR=PowerUP-$RELEASE_NUMBER-$VICE_VERSION
        else
          AMIGAFLAVOR=PowerUP-$VICE_VERSION-$DTV_REVISION
        fi
        echo Generating PowerUP port binary distribution.
      else
        if test x"$HOST_CPU" = "xm68k"; then
          if test x"$RELEASE" = "xyes"; then
            AMIGAFLAVOR=AmigaOS3-$RELEASE_NUMBER-$VICE_VERSION
          else
            AMIGAFLAVOR=AmigaOS3-$VICE_VERSION-$DTV_REVISION
          fi
          echo Generating AmigaOS3 port binary distribution.
        else
          if test x"$RELEASE" = "xyes"; then
            AMIGAFLAVOR=AmigaOS4-$RELEASE_NUMBER-$VICE_VERSION
          else
            AMIGAFLAVOR=AmigaOS4-$VICE_VERSION-$DTV_REVISION
          fi
          echo Generating AmigaOS4 port binary distribution.
        fi
      fi
    fi
  fi
fi

rm -f -r $DTV_NAME-$AMIGAFLAVOR $DTV_NAME-$AMIGAFLAVOR.info
mkdir $DTV_NAME-$AMIGAFLAVOR
if test x"$HOST_SYSTEM" != "xaros"; then
  $STRIP src/x64$EXE_EXT
  $STRIP src/x64dtv$EXE_EXT
  $STRIP src/x128$EXE_EXT
  $STRIP src/xvic$EXE_EXT
  $STRIP src/xpet$EXE_EXT
  $STRIP src/xplus4$EXE_EXT
  $STRIP src/xcbm2$EXE_EXT
  $STRIP src/c1541$EXE_EXT
  $STRIP src/petcat$EXE_EXT
  $STRIP src/cartconv$EXE_EXT
  $STRIP src/arch/amigaos/x64ns$EXE_EXT
  $STRIP src/arch/amigaos/x64dtvns$EXE_EXT
  $STRIP src/arch/amigaos/x128ns$EXE_EXT
  $STRIP src/arch/amigaos/xvicns$EXE_EXT
  $STRIP src/arch/amigaos/xpetns$EXE_EXT
  $STRIP src/arch/amigaos/xplus4ns$EXE_EXT
  $STRIP src/arch/amigaos/xcbm2ns$EXE_EXT
else
  $STRIP --strip-unneeded --remove-section .comment src/x64$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/x64dtv$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/x128$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/xvic$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/xpet$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/xplus4$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/xcbm2$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/c1541$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/petcat$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/cartconv$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/arch/amigaos/x64ns$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/arch/amigaos/x64dtvns$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/arch/amigaos/x128ns$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/arch/amigaos/xvicns$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/arch/amigaos/xpetns$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/arch/amigaos/xplus4ns$EXE_EXT
  $STRIP --strip-unneeded --remove-section .comment src/arch/amigaos/xcbm2ns$EXE_EXT
fi
if test x"$HOST_SYSTEM" = "xmorphos"; then
  cp src/x64$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x64
  cp src/x64dtv$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x64dtv
  cp src/x128$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x128
  cp src/xvic$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xvic
  cp src/xpet$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xpet
  cp src/xplus4$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xplus4
  cp src/xcbm2$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xcbm2
  cp src/c1541$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/c1541
  cp src/petcat$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/petcat
  cp src/cartconv$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/cartconv
  cp src/arch/amigaos/x64ns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x64\ \(no\ sound\)
  cp src/arch/amigaos/x64dtvns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x64dtv\ \(no\ sound\)
  cp src/arch/amigaos/x128ns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x128\ \(no\ sound\)
  cp src/arch/amigaos/xvicns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xvic\ \(no\ sound\)
  cp src/arch/amigaos/xpetns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xpet\ \(no\ sound\)
  cp src/arch/amigaos/xplus4ns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xplus4\ \(no\ sound\)
  cp src/arch/amigaos/xcbm2ns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xcbm2\ \(no\ sound\)
else
  cp src/x64$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x64.exe
  cp src/x64dtv$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x64dtv.exe
  cp src/x128$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x128.exe
  cp src/xvic$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xvic.exe
  cp src/xpet$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xpet.exe
  cp src/xplus4$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xplus4.exe
  cp src/xcbm2$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xcbm2.exe
  cp src/c1541$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/c1541.exe
  cp src/petcat$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/petcat.exe
  cp src/cartconv$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/cartconv.exe
  cp src/arch/amigaos/x64ns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x64\ \(no\ sound\).exe
  cp src/arch/amigaos/x64dtvns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x64dtv\ \(no\ sound\).exe
  cp src/arch/amigaos/x128ns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/x128\ \(no\ sound\).exe
  cp src/arch/amigaos/xvicns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xvic\ \(no\ sound\).exe
  cp src/arch/amigaos/xpetns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xpet\ \(no\ sound\).exe
  cp src/arch/amigaos/xplus4ns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xplus4\ \(no\ sound\).exe
  cp src/arch/amigaos/xcbm2ns$EXE_EXT $DTV_NAME-$AMIGAFLAVOR/xcbm2\ \(no\ sound\).exe
fi
cp -a $TOP_SRC_DIR/data/C128 $TOP_SRC_DIR/data/C64 $TOP_SRC_DIR/data/C64DTV $TOP_SRC_DIR/data/CBM-II $TOP_SRC_DIR/data/DRIVES $DTV_NAME-$AMIGAFLAVOR
cp -a $TOP_SRC_DIR/data/PET $TOP_SRC_DIR/data/PLUS4 $TOP_SRC_DIR/data/PRINTER $TOP_SRC_DIR/data/VIC20 $DTV_NAME-$AMIGAFLAVOR
cp -a data/C128 data/C64 data/C64DTV data/CBM-II data/DRIVES $DTV_NAME-$AMIGAFLAVOR
cp -a data/PET data/PLUS4 data/PRINTER data/VIC20 $DTV_NAME-$AMIGAFLAVOR
cp -a $TOP_SRC_DIR/data/fonts $DTV_NAME-$AMIGAFLAVOR
cp -a $TOP_SRC_DIR/doc/html $DTV_NAME-$AMIGAFLAVOR
cp $TOP_SRC_DIR/FEEDBACK $TOP_SRC_DIR/README $TOP_SRC_DIR/doc/cartconv.txt $DTV_NAME-$AMIGAFLAVOR
cp $TOP_SRC_DIR/src/arch/amigaos/README.AMIGA $TOP_SRC_DIR/doc/Readme.x64dtv $DTV_NAME-$AMIGAFLAVOR
if test x"$HOST_SYSTEM" = "xwarpos"; then
  for i in cartconv.exe c1541.exe petcat.exe x64.exe x64dtv.exe x128.exe xcbm2.exe \
           xpet.exe xplus4.exe xvic.exe
  do
    elf2exe $DTV_NAME-$AMIGAFLAVOR/$i $DTV_NAME-$AMIGAFLAVOR/$i.new
    mv -f $DTV_NAME-$AMIGAFLAVOR/$i.new $DTV_NAME-$AMIGAFLAVOR/$i
  done
fi
if test x"$HOST_SYSTEM" = "xmorphos"; then
  cp $TOP_SRC_DIR/src/arch/amigaos/info-files/morphos/VICE.info $DTV_NAME-$AMIGAFLAVOR.info
  cp $TOP_SRC_DIR/src/arch/amigaos/info-files/morphos/x*.info $DTV_NAME-$AMIGAFLAVOR
  cp $DTV_NAME-$AMIGAFLAVOR/x64.info $DTV_NAME-$AMIGAFLAVOR/x64dtv.info
  cp $DTV_NAME-$AMIGAFLAVOR/x64.info $DTV_NAME-$AMIGAFLAVOR/x64\ \(no\ sound\).info
  cp $DTV_NAME-$AMIGAFLAVOR/x64.info $DTV_NAME-$AMIGAFLAVOR/x64dtv\ \(no\ sound\).info
  cp $DTV_NAME-$AMIGAFLAVOR/x128.info $DTV_NAME-$AMIGAFLAVOR/x128\ \(no\ sound\).info
  cp $DTV_NAME-$AMIGAFLAVOR/xvic.info $DTV_NAME-$AMIGAFLAVOR/xvic\ \(no\ sound\).info
  cp $DTV_NAME-$AMIGAFLAVOR/xpet.info $DTV_NAME-$AMIGAFLAVOR/xpet\ \(no\ sound\).info
  cp $DTV_NAME-$AMIGAFLAVOR/xplus4.info $DTV_NAME-$AMIGAFLAVOR/xplus4\ \(no\ sound\).info
  cp $DTV_NAME-$AMIGAFLAVOR/xcbm2.info $DTV_NAME-$AMIGAFLAVOR/xcbm2\ \(no\ sound\).info
else
  cp $TOP_SRC_DIR/src/arch/amigaos/info-files/VICE.info $DTV_NAME-$AMIGAFLAVOR.info
  cp $TOP_SRC_DIR/src/arch/amigaos/info-files/*.exe.info $DTV_NAME-$AMIGAFLAVOR
  cp $DTV_NAME-$AMIGAFLAVOR/x64.exe.info $DTV_NAME-$AMIGAFLAVOR/x64dtv.exe.info
  cp $DTV_NAME-$AMIGAFLAVOR/x64.exe.info $DTV_NAME-$AMIGAFLAVOR/x64\ \(no\ sound\).exe.info
  cp $DTV_NAME-$AMIGAFLAVOR/x64.exe.info $DTV_NAME-$AMIGAFLAVOR/x64dtv\ \(no\ sound\).exe.info
  cp $DTV_NAME-$AMIGAFLAVOR/x128.exe.info $DTV_NAME-$AMIGAFLAVOR/x128\ \(no\ sound\).exe.info
  cp $DTV_NAME-$AMIGAFLAVOR/xvic.exe.info $DTV_NAME-$AMIGAFLAVOR/xvic\ \(no\ sound\).exe.info
  cp $DTV_NAME-$AMIGAFLAVOR/xpet.exe.info $DTV_NAME-$AMIGAFLAVOR/xpet\ \(no\ sound\).exe.info
  cp $DTV_NAME-$AMIGAFLAVOR/xplus4.exe.info $DTV_NAME-$AMIGAFLAVOR/xplus4\ \(no\ sound\).exe.info
  cp $DTV_NAME-$AMIGAFLAVOR/xcbm2.exe.info $DTV_NAME-$AMIGAFLAVOR/xcbm2\ \(no\ sound\).exe.info
fi
rm `find $DTV_NAME-$AMIGAFLAVOR -name "Makefile*"`
rm `find $DTV_NAME-$AMIGAFLAVOR -name "dos_*.vkm"`
rm `find $DTV_NAME-$AMIGAFLAVOR -name "os2*.vkm"`
rm `find $DTV_NAME-$AMIGAFLAVOR -name "osx*.vkm"`
rm `find $DTV_NAME-$AMIGAFLAVOR -name "beos_*.vkm"`
rm `find $DTV_NAME-$AMIGAFLAVOR -name "win_*.vkm"`
rm `find $DTV_NAME-$AMIGAFLAVOR -name "x11_*.vkm"`
rm `find $DTV_NAME-$AMIGAFLAVOR -name "RO*.vkm"`
rm $DTV_NAME-$AMIGAFLAVOR/html/texi2html
if test x"$ZIPKIND" = "xzip"; then
  tar cf $DTV_NAME-$AMIGAFLAVOR.tar $DTV_NAME-$AMIGAFLAVOR $DTV_NAME-$AMIGAFLAVOR.info
  gzip $DTV_NAME-$AMIGAFLAVOR.tar
  rm -f -r $DTV_NAME-$AMIGAFLAVOR $DTV_NAME-$AMIGAFLAVOR.info
  echo AMIGA port binary distribution archive generated as $DTV_NAME-$AMIGAFLAVOR.tar.gz
else
  echo AMIGA port binary destribution directory generated as $DTV_NAME-$AMIGAFLAVOR
fi
