#!/bin/sh
# make-bindist.sh for the BEOS port
#
# written by Marco van den Heuvel <blackystardust68@yahoo.com>
#
# make-bindist.sh <strip> <vice-version> <dtv-name> <dtv-revision> <cpu> <zip|nozip> <top-srcdir> <release> <release-number>
#                 $1      $2             $3         $4             $5    $6          $7           $8        $9

STRIP=$1
VICE_VERSION=$2
DTV_NAME=$3
DTV_REVISION=$4
CPU=$5
ZIPKIND=$6
TOP_SRC_DIR=$7
RELEASE=$8
RELEASE_NUMBER=$9

if [ ! -e src/x64 -o ! -e src/x64dtv -o ! -e src/x128 -o ! -e src/xvic -o ! -e src/xpet -o ! -e src/xplus4 -o ! -e src/xcbm2 -o ! -e src/c1541 -o ! -e src/petcat -o ! -e src/cartconv ]
then
  echo Error: executable file\(s\) not found, do a \"make\" first
  exit 1
fi

echo Generating BEOS port binary distribution.
if test x"$CPU" = "powerpc"; then
  BEOSCPU=powerpc
else
  BEOSCPU=x86
fi

if test x"$RELEASE" = "xyes"; then
  BEOSPORT=Be$DTV_NAME-$RELEASE_NUMBER-$VICE_VERSION.$BEOSCPU
else
  BEOSPORT=Be$DTV_NAME-$VICE_VERSION-$DTV_REVISION.$BEOSCPU
fi

rm -f -r $BEOSPORT
mkdir $BEOSPORT
$STRIP src/x64
$STRIP src/x64dtv
$STRIP src/x128
$STRIP src/xvic
$STRIP src/xpet
$STRIP src/xplus4
$STRIP src/xcbm2
$STRIP src/c1541
$STRIP src/petcat
$STRIP src/cartconv
cp src/x64 src/x64dtv src/x128 src/xvic $BEOSPORT
cp src/xpet src/xplus4 src/xcbm2 $BEOSPORT
cp src/c1541 src/petcat src/cartconv $BEOSPORT
cp -a data/C128 data/C64 data/C64DTV data/CBM-II data/DRIVES $BEOSPORT
cp -a data/PET data/PLUS4 data/PRINTER data/VIC20 $BEOSPORT
cp -a data/fonts $BEOSPORT
mkdir $BEOSPORT/doc
cp -a $TOP_SRC_DIR/doc/html $BEOSPORT/doc
cp $TOP_SRC_DIR/doc/iec-bus.txt $BEOSPORT/doc
cp $TOP_SRC_DIR/doc/mon.txt $BEOSPORT/doc
cp $TOP_SRC_DIR/doc/cartconv.txt $BEOSPORT/doc
cp $TOP_SRC_DIR/doc/Readme.beos $BEOSPORT/doc
cp $TOP_SRC_DIR/doc/Readme.x64dtv $BEOSPORT/doc
cp $TOP_SRC_DIR/FEEDBACK $TOP_SRC_DIR/README $BEOSPORT
rm `find $BEOSPORT -name "Makefile*"`
rm `find $BEOSPORT -name "amiga_*.vkm"`
rm `find $BEOSPORT -name "dos_*.vkm"`
rm `find $BEOSPORT -name "os2*.vkm"`
rm `find $BEOSPORT -name "osx*.vkm"`
rm `find $BEOSPORT -name "win_*.vkm"`
rm `find $BEOSPORT -name "x11_*.vkm"`
rm $BEOSPORT/html/texi2html
if test x"$ZIPKIND" = "xzip"; then
  if test x"$ZIP" = "x"; then
    zip -r -9 -q $BEOSPORT.zip $BEOSPORT
  else
    $ZIP $BEOSPORT.zip $BEOSPORT
  fi
  rm -f -r $BEOSPORT
  echo BEOS port binary distribution archive generated as $BEOSPORT.zip
else
  echo BEOS port binary distribution directory generated as $BEOSPORT
fi
