#!/bin/sh
# make-bindist.sh for the MSDOS port
#
# written by Marco van den Heuvel <blackystardust68@yahoo.com>
#
# make-bindist.sh <strip> <vice-ver-major> <vice-ver-minor> <dtv-revision> <zip|nozip> <top-srcdir> <release> <release-number>
#                 $1      $2               $3               $4             $5          $6           $7        $8

STRIP=$1
VICE_VER_MAJOR=$2
VICE_VER_MINOR=$3
DTV_REVISION=$4
ZIPKIND=$5
TOP_SRC_DIR=$6
RELEASE=$7
DTV_RELEASE_NUMBER=$8

if [ ! -e src/x64.exe -o ! -e src/x64dtv.exe -o ! -e src/x128.exe -o ! -e src/xvic.exe -o ! -e src/xpet.exe -o ! -e src/xplus4.exe -o ! -e src/xcbm2.exe -o ! -e src/c1541.exe -o ! -e src/petcat.exe -o ! -e src/cartconv.exe ]
then
  echo Error: executable file\(s\) not found, do a \"make\" first
  exit 1
fi

if test x"$RELEASE" = "xyes"; then
  RELEASE_NUMBER=`echo $DTV_RELEASE_NUMBER | cut -c 2,4`
  ZIPNAME=vp$RELEASE_NUMBER-$VICE_VER_MAJOR$DTV_REVISION
else
  ZIPNAME=vp$VICE_VER_MAJOR$VICE_VER_MINOR$DTV_REVISION
fi

echo Generating MSDOS port binary distribution.
rm -f -r dosvicep
mkdir dosvicep
$STRIP src/x64.exe
$STRIP src/x64dtv.exe
$STRIP src/x128.exe
$STRIP src/xvic.exe
$STRIP src/xpet.exe
$STRIP src/xplus4.exe
$STRIP src/xcbm2.exe
$STRIP src/c1541.exe
$STRIP src/petcat.exe
$STRIP src/cartconv.exe
cp src/x64.exe src/x64dtv.exe src/x128.exe src/xvic.exe dosvicep
cp src/xpet.exe src/xplus4.exe src/xcbm2.exe dosvicep
cp src/c1541.exe src/petcat.exe src/cartconv.exe dosvicep
cp -a $TOP_SRC_DIR/data/C128 $TOP_SRC_DIR/data/C64 $TOP_SRC_DIR/data/C64DTV $TOP_SRC_DIR/data/CBM-II $TOP_SRC_DIR/data/DRIVES dosvicep
cp -a $TOP_SRC_DIR/data/PET $TOP_SRC_DIR/data/PLUS4 $TOP_SRC_DIR/data/PRINTER $TOP_SRC_DIR/data/VIC20 dosvicep
cp -a $TOP_SRC_DIR/data/fonts dosvicep
cp -a $TOP_SRC_DIR/doc/html dosvicep
cp $TOP_SRC_DIR/FEEDBACK $TOP_SRC_DIR/README dosvicep
cp $TOP_SRC_DIR/doc/Readme.dos dosvicep
cp $TOP_SRC_DIR/doc/cartconv.txt dosvicep
cp $TOP_SRC_DIR/doc/Readme.x64dtv dosvicep/Readme.dtv
rm `find dosvicep -name "Makefile*"`
rm `find dosvicep -name "amiga_*.vkm"`
rm `find dosvicep -name "os2*.vkm"`
rm `find dosvicep -name "osx*.vkm"`
rm `find dosvicep -name "beos_*.vkm"`
rm `find dosvicep -name "win_*.vkm"`
rm `find dosvicep -name "x11_*.vkm"`
rm `find dosvicep -name "RO*.vkm"`
rm dosvicep/html/texi2html
if test x"$ZIPKIND" = "xzip"; then
  if test x"$ZIP" = "x"; then
    zip -r -9 -q $ZIPNAME.zip dosvicep
  else
    $ZIP $ZIPNAME.zip dosvicep
  fi
  rm -f -r dosvicep
  echo MSDOS port binary distribution archive generated as $ZIPNAME.zip
else
  echo MSDOS port binary distribution directory generated as dosvicep
fi
