#!/bin/sh
# make-bindist.sh for the QNX 6.x port
#
# written by Marco van den Heuvel <blackystardust68@yahoo.com>
#
# make-bindist.sh <strip> <vice-version> <dtv-name> <dtv-revision> <prefix> <cross> <zip|nozip> <topsrcdir> <release> <release-number> <dtvrom-install>
#                 $1      $2             $3         $4             $5       $6      $7          $8          $9        $10              $11

STRIP=$1
VICE_VERSION=$2
DTV_NAME=$3
DTV_REVISION=$4
PREFIX=$5
CROSS=$6
ZIPKIND=$7
TOP_SRC_DIR=$8
RELEASE=$9

shift
RELEASE_NUMBER=$9

shift
DTVROM_INSTALL=$9

if test x"$PREFIX" != "x/opt"; then
  echo Error: installation path is not /opt
  exit 1
fi

if test x"$CROSS" = "xtrue"; then
  echo Error: \"make bindist\" for QNX can only be done on QNX
  exit 1
fi

if [ ! -e /opt/bin/x64 -o ! -e /opt/bin/x64dtv -o ! -e /opt/bin/x128 -o ! -e /opt/bin/xvic -o ! -e /opt/bin/xpet -o ! -e /opt/bin/xplus4 -o ! -e /opt/bin/xcbm2 -o ! -e /opt/bin/c1541 -o ! -e /opt/bin/petcat -o ! -e /opt/bin/cartconv ]
then
  echo Error: \"make install\" needs to be done first
  exit 1
fi

if test x"$RELEASE" = "xyes"; then
  QNXPORT=$DTV_NAME-$RELEASE_NUMBER-$VICE_VERSION
  QNXVER=$RELEASE_NUMBER-$VICE_VERSION
else
  QNXPORT=$DTV_NAME-$VICE_VERSION-$DTV_REVISION
  QNXVER=$VICE_VERSION-$DTV_REVISION
fi

echo Generating QNX port binary distribution.
rm -f -r $QNXPORT
mkdir $QNXPORT
mkdir $QNXPORT/opt
mkdir -p $QNXPORT/opt/lib/locale/de/LC_MESSAGES
mv /opt/lib/locale/de/LC_MESSAGES/$DTV_NAME.* $QNXPORT/opt/lib/locale/de/LC_MESSAGES
mkdir -p $QNXPORT/opt/lib/locale/fr/LC_MESSAGES
mv /opt/lib/locale/fr/LC_MESSAGES/$DTV_NAME.* $QNXPORT/opt/lib/locale/fr/LC_MESSAGES
mkdir -p $QNXPORT/opt/lib/locale/it/LC_MESSAGES
mv /opt/lib/locale/it/LC_MESSAGES/$DTV_NAME.* $QNXPORT/opt/lib/locale/it/LC_MESSAGES
mkdir -p $QNXPORT/opt/lib/locale/sv/LC_MESSAGES
mv /opt/lib/locale/sv/LC_MESSAGES/$DTV_NAME.* $QNXPORT/opt/lib/locale/sv/LC_MESSAGES
mkdir -p $QNXPORT/opt/lib/locale/pl/LC_MESSAGES
mv /opt/lib/locale/pl/LC_MESSAGES/$DTV_NAME.* $QNXPORT/opt/lib/locale/pl/LC_MESSAGES
mkdir -p $QNXPORT/opt/lib/locale/nl/LC_MESSAGES
mv /opt/lib/locale/nl/LC_MESSAGES/$DTV_NAME.* $QNXPORT/opt/lib/locale/nl/LC_MESSAGES
mkdir -p $QNXPORT/opt/lib/locale/hu/LC_MESSAGES
mv /opt/lib/locale/hu/LC_MESSAGES/$DTV_NAME.* $QNXPORT/opt/lib/locale/hu/LC_MESSAGES
mkdir $QNXPORT/opt/bin
mv /opt/bin/vsid $QNXPORT/opt/bin
mv /opt/bin/x64 $QNXPORT/opt/bin
$STRIP $QNXPORT/opt/bin/x64
mv /opt/bin/x64dtv $QNXPORT/opt/bin
$STRIP $QNXPORT/opt/bin/x64dtv
mv /opt/bin/x128 $QNXPORT/opt/bin
$STRIP $QNXPORT/opt/bin/x128
mv /opt/bin/xvic $QNXPORT/opt/bin
$STRIP $QNXPORT/opt/bin/xvic
mv /opt/bin/xpet $QNXPORT/opt/bin
$STRIP $QNXPORT/opt/bin/xpet
mv /opt/bin/xplus4 $QNXPORT/opt/bin
$STRIP $QNXPORT/opt/bin/xplus4
mv /opt/bin/xcbm2 $QNXPORT/opt/bin
$STRIP $QNXPORT/opt/bin/xcbm2
mv /opt/bin/c1541 $QNXPORT/opt/bin
$STRIP $QNXPORT/opt/bin/c1541
mv /opt/bin/petcat $QNXPORT/opt/bin
$STRIP $QNXPORT/opt/bin/petcat
mv /opt/bin/cartconv $QNXPORT/opt/bin
$STRIP $QNXPORT/opt/bin/cartconv
mv /opt/lib/vice $QNXPORT/opt/lib
rm `find $QNXPORT -name "amiga_*.vkm"`
rm `find $QNXPORT -name "beos_*.vkm"`
rm `find $QNXPORT -name "dos_*.vkm"`
rm `find $QNXPORT -name "os2*.vkm"`
rm `find $QNXPORT -name "osx*.vkm"`
rm `find $QNXPORT -name "win_*.vkm"`
rm `find $QNXPORT -name "RO*.vkm"`
mkdir -p $QNXPORT/opt/man/man1
mv /opt/man/man1/c1541.1 $QNXPORT/opt/man/man1
mv /opt/man/man1/petcat.1 $QNXPORT/opt/man/man1
mv /opt/man/man1/vice.1 $QNXPORT/opt/man/man1
mkdir $QNXPORT/opt/info
mv /opt/info/vice.info* $QNXPORT/opt/info
if test x"$ZIPKIND" = "xzip"; then
  gcc $TOP_SRC_DIR/src/arch/unix/qnx/getsize.c -o ./getsize
  gcc $TOP_SRC_DIR/src/arch/unix/qnx/getlibs.c -o ./getlibs
  mkdir -p public/$DTV_NAME/core-$QNXVER/x86/opt/bin
  mv $QNXPORT/opt/bin/x* public/$DTV_NAME/core-$QNXVER/x86/opt/bin
  mv $QNXPORT/opt/bin/c1541 public/$DTV_NAME/core-$QNXVER/x86/opt/bin
  mv $QNXPORT/opt/bin/cartconv public/$DTV_NAME/core-$QNXVER/x86/opt/bin
  mv $QNXPORT/opt/bin/petcat public/$DTV_NAME/core-$QNXVER/x86/opt/bin

  current_date=`date +%Y/%m/%d`

cat >manifest.01 <<_END
<?xml version="1.0"?>
<RDF:RDF xmlns:RDF="http://www.w3.org" xmlns:QPM="http://www.qnx.com">
   <RDF:Description about="http://www.qnx.com">
      <QPM:PackageManifest>
         <QPM:PackageDescription>
            <QPM:PackageType>Application</QPM:PackageType>
            <QPM:PackageName>$QNXPORT-x86-public</QPM:PackageName>
_END

echo >manifest.02 "            <QPM:PackageSize/>"

cat >manifest.03 <<_END
            <QPM:PackageReleaseNumber>1</QPM:PackageReleaseNumber>
            <QPM:PackageReleaseDate>$current_date</QPM:PackageReleaseDate>
            <QPM:PackageRepository/>
            <QPM:FileVersion>2.0</QPM:FileVersion>
         </QPM:PackageDescription>

         <QPM:ProductDescription>
            <QPM:ProductName>$DTV_NAME for x86</QPM:ProductName>
_END

  ls -l -R public/$DTV_NAME/core-$QNXVER/x86/opt >size.tmp
  manifest_size=`./getsize size.tmp`
  rm -f -r size.tmp
  echo >manifest.04 "            <QPM:ProductSize>$manifest_size</QPM:ProductSize>"

  echo >manifest.05 "            <QPM:ProductIdentifier>$DTV_NAME-host_x86</QPM:ProductIdentifier>"

  cat >manifest.06 <<_END
            <QPM:ProductEmail>viceplusteam@yahoo.com</QPM:ProductEmail>
            <QPM:VendorName>Public</QPM:VendorName>
            <QPM:VendorInstallName>public</QPM:VendorInstallName>
            <QPM:VendorURL>http://viceplus.sourceforge.net</QPM:VendorURL>
            <QPM:VendorEmbedURL/>
            <QPM:VendorEmail>viceplusteam@yahoo.com</QPM:VendorEmail>
            <QPM:AuthorName>The VICEplus Team</QPM:AuthorName>
            <QPM:AuthorURL>http://viceplus.sourceforge.net</QPM:AuthorURL>
            <QPM:AuthorEmbedURL/>
            <QPM:AuthorEmail>viceplusteam@yahoo.com</QPM:AuthorEmail>
            <QPM:ProductIconSmall>http://picobay.com/dtv_wiki/index.php?title=Image:VICEplus-logo.png</QPM:ProductIconSmall>
            <QPM:ProductIconLarge>http://picobay.com/dtv_wiki/index.php?title=Image:VICEplus-logo.png</QPM:ProductIconLarge>
            <QPM:ProductDescriptionShort>The Versatile Commodore Emulator plus</QPM:ProductDescriptionShort>
            <QPM:ProductDescriptionLong>VICEplus is a program that runs on a Unix, MS-DOS, Win32, OS/2, Acorn RISC OS, QNX 6.x, AmigaOS or BeOS machine and executes programs intended for the old 8-bit computers. The current version emulates the C64, the C64DTV, the C128, the VIC20, all the PET models (except the SuperPET 9000, which is out of line anyway), the PLUS4 and the CBM-II (aka C610).</QPM:ProductDescriptionLong>
            <QPM:ProductDescriptionURL>http://viceplus.sourceforge.net</QPM:ProductDescriptionURL>
            <QPM:ProductDescriptionEmbedURL/>
_END

echo >manifest.07 "            <QPM:InstallPath>public/$DTV_NAME/core-$QNXVER/x86</QPM:InstallPath>"

cat >manifest.08 <<_END
         </QPM:ProductDescription>

         <QPM:ReleaseDescription>
            <QPM:ReleaseDate>$current_date</QPM:ReleaseDate>
            <QPM:ReleaseVersion>$QNXVER</QPM:ReleaseVersion>
            <QPM:ReleaseUrgency>High</QPM:ReleaseUrgency>
            <QPM:ReleaseStability>Stable</QPM:ReleaseStability>
            <QPM:ReleaseNoteMinor/>
            <QPM:ReleaseNoteMajor/>
            <QPM:ReleaseBuild>1</QPM:ReleaseBuild>
            <QPM:ExcludeCountries>
               <QPM:Country/>
            </QPM:ExcludeCountries>

            <QPM:ReleaseCopyright>GNU General Public License</QPM:ReleaseCopyright>
         </QPM:ReleaseDescription>

         <QPM:LicenseUrl>rep://$QNXPORT-public.repdata/LicenseUrl/COPYING</QPM:LicenseUrl>
         <QPM:ProductKeyUrl/>
         <QPM:RelationshipDescription>
_END

cat >manifest.09 <<_END
            <QPM:RelationshipType>component</QPM:RelationshipType>
            <QPM:ComponentType>Required</QPM:ComponentType>
            <QPM:ComponentParent>$DTV_NAME</QPM:ComponentParent>
_END

cat >manifest.10 <<_END
            <QPM:ComponentFilter/>
         </QPM:RelationshipDescription>

         <QPM:ContentDescription>
            <QPM:ContentTopic>Games and Diversions/Game Emulatiors</QPM:ContentTopic>
            <QPM:ContentKeyword>c64,c64dtv,c128,vic20,plus4,c16,cbm510,cbm610,c510,c610,cbm,commodore,emulator,pet</QPM:ContentKeyword>
_END

echo >manifest.11 "            <QPM:Processor>x86</QPM:Processor>"

cat >manifest.12 <<_END
            <QPM:TargetProcessor/>
            <QPM:TargetOS>qnx6</QPM:TargetOS>
            <QPM:HostOS>none</QPM:HostOS>
            <QPM:DisplayEnvironment>X11R6</QPM:DisplayEnvironment>
            <QPM:TargetAudience>User</QPM:TargetAudience>
_END

  ./getlibs public/$DTV_NAME/core-$QNXVER/x86/opt/bin/x64 >manifest.13

cat >manifest.14 <<_END
         </QPM:ContentDescription>

         <QPM:ProductInstallationDependencies>
            <QPM:ProductRequirements>This package requires the following libraries to operate correctly : libintl, libSDL, libpng, libX11.</QPM:ProductRequirements>
         </QPM:ProductInstallationDependencies>
_END

cat >manifest.15 <<_END
         <QPM:QNXLicenseDescription/>
      </QPM:PackageManifest>

      <QPM:FileManifest>
         <QPM:Listing>
            <QPM:Dir name="">
               <QPM:Dir name="opt">
                  <QPM:Dir name="bin">
                     <QPM:File>c1541</QPM:File>
                     <QPM:File>petcat</QPM:File>
                     <QPM:File>cartconv</QPM:File>
                     <QPM:File>x128</QPM:File>
                     <QPM:File>x64</QPM:File>
                     <QPM:File>x64dtv</QPM:File>
                     <QPM:File>xcbm2</QPM:File>
                     <QPM:File>xpet</QPM:File>
                     <QPM:File>xplus4</QPM:File>
                     <QPM:File>xvic</QPM:File>
                  </QPM:Dir>
               </QPM:Dir>
            </QPM:Dir>
         </QPM:Listing>
      </QPM:FileManifest>
   </RDF:Description>
</RDF:RDF>
_END

  cat >public/$DTV_NAME/core-$QNXVER/x86/MANIFEST manifest.01 manifest.02 \
      manifest.03 manifest.04 manifest.05 manifest.06 manifest.07 manifest.08 \
      manifest.09 manifest.10 manifest.11 manifest.12 manifest.13 manifest.14 \
      manifest.15

  tar cf $DTV_NAME-x86.tar public
  gzip $DTV_NAME-x86.tar
  mv $DTV_NAME-x86.tar.gz $QNXPORT-x86-public.qpk

  ls -l -R $QNXPORT-x86-public.qpk >size.tmp
  manifest_size=`./getsize size.tmp` 
  rm -f -r size.tmp

  echo >manifest.04 "            <QPM:PackageSize>$manifest_size</QPM:PackageSize>"

  cat >$QNXPORT-x86-public.qpm manifest.01 manifest.02 manifest.03 manifest.04 \
      manifest.05 manifest.06 manifest.07 manifest.08 manifest.09 manifest.10 \
      manifest.11 manifest.12 manifest.13 manifest.14 manifest.15

  rm -f -r public

  mkdir -p public/$DTV_NAME/core-$QNXVER
  mv $QNXPORT/opt public/$DTV_NAME/core-$QNXVER

  mkdir -p $QNXPORT-public.repdata/LicenseUrl
  cp public/$DTV_NAME/core-$QNXVER/opt/lib/vice/doc/COPYING $QNXPORT-public.repdata/LicenseUrl

  echo >manifest.02 "            <QPM:PackageSize/>"

  ls -l -R public/$DTV_NAME/core-$QNXVER/opt >size.tmp
  manifest_size=`./getsize size.tmp`
  rm -f -r size.tmp
  echo >manifest.04 "            <QPM:ProductSize>$manifest_size</QPM:ProductSize>"

  echo >manifest.05 "            <QPM:ProductIdentifier>$DTV_NAME</QPM:ProductIdentifier>"

  echo >manifest.07 "            <QPM:InstallPath>public/$DTV_NAME/core-$QNXVER</QPM:InstallPath>"

  cat >manifest.09 <<_END
            <QPM:RelationshipType>core</QPM:RelationshipType>
            <QPM:ComponentType>Required</QPM:ComponentType>
            <QPM:ComponentParent/>
_END

  echo >manifest.11 "            <QPM:Processor/>"

  cat >manifest.15 <<_END
         <QPM:ProductInstallationProcedure>
            <QPM:Script>
               <QPM:ScriptName>/usr/photon/bin/launchmenu_notify</QPM:ScriptName>
               <QPM:ScriptTiming>Post</QPM:ScriptTiming>
               <QPM:ScriptType>Use</QPM:ScriptType>
            </QPM:Script>

            <QPM:Script>
               <QPM:ScriptName>/usr/photon/bin/launchmenu_notify</QPM:ScriptName>
               <QPM:ScriptTiming>Post</QPM:ScriptTiming>
               <QPM:ScriptType>Unuse</QPM:ScriptType>
            </QPM:Script>
         </QPM:ProductInstallationProcedure>

         <QPM:QNXLicenseDescription/>
      </QPM:PackageManifest>

      <QPM:FileManifest>
         <QPM:PkgInclude>
            <QPM:Item>\$(PROCESSOR)/MANIFEST</QPM:Item>
         </QPM:PkgInclude>

         <QPM:Listing>
            <QPM:Dir name="">
               <QPM:Dir name="opt">
                  <QPM:Union link="../\$(PROCESSOR)/opt/bin">bin</QPM:Union>
                  <QPM:Dir name="bin">
                     <QPM:File>vsid</QPM:File>
                  </QPM:Dir>

                  <QPM:Dir name="info">
                     <QPM:File>vice.info</QPM:File>
                     <QPM:File>vice.info-1</QPM:File>
                     <QPM:File>vice.info-2</QPM:File>
                     <QPM:File>vice.info-3</QPM:File>
                     <QPM:File>vice.info-4</QPM:File>
                     <QPM:File>vice.info-5</QPM:File>
                     <QPM:File>vice.info-6</QPM:File>
                  </QPM:Dir>

                  <QPM:Dir name="lib">
                     <QPM:Dir name="locale">
                        <QPM:Dir name="de">
                           <QPM:Dir name="LC_MESSAGES">
                              <QPM:File>$DTV_NAME.mo</QPM:File>
                           </QPM:Dir>
                        </QPM:Dir>

                        <QPM:Dir name="fr">
                           <QPM:Dir name="LC_MESSAGES">
                              <QPM:File>$DTV_NAME.mo</QPM:File>
                           </QPM:Dir>
                        </QPM:Dir>

                        <QPM:Dir name="hu">
                           <QPM:Dir name="LC_MESSAGES">
                              <QPM:File>$DTV_NAME.mo</QPM:File>
                           </QPM:Dir>
                        </QPM:Dir>

                        <QPM:Dir name="it">
                           <QPM:Dir name="LC_MESSAGES">
                              <QPM:File>$DTV_NAME.mo</QPM:File>
                           </QPM:Dir>
                        </QPM:Dir>

                        <QPM:Dir name="nl">
                           <QPM:Dir name="LC_MESSAGES">
                              <QPM:File>$DTV_NAME.mo</QPM:File>
                           </QPM:Dir>
                        </QPM:Dir>

                        <QPM:Dir name="pl">
                           <QPM:Dir name="LC_MESSAGES">
                              <QPM:File>$DTV_NAME.mo</QPM:File>
                           </QPM:Dir>
                        </QPM:Dir>

                        <QPM:Dir name="sv">
                           <QPM:Dir name="LC_MESSAGES">
                              <QPM:File>$DTV_NAME.mo</QPM:File>
                           </QPM:Dir>
                        </QPM:Dir>
                     </QPM:Dir>

                     <QPM:Dir name="vice">
                        <QPM:Dir name="C128">
                           <QPM:File>basic64</QPM:File>
                           <QPM:File>basichi</QPM:File>
                           <QPM:File>basiclo</QPM:File>
                           <QPM:File>c64hq.vpl</QPM:File>
                           <QPM:File>c64s.vpl</QPM:File>
                           <QPM:File>ccs64.vpl</QPM:File>
                           <QPM:File>chargde</QPM:File>
                           <QPM:File>chargen</QPM:File>
                           <QPM:File>chargfr</QPM:File>
                           <QPM:File>chargse</QPM:File>
                           <QPM:File>default.vpl</QPM:File>
                           <QPM:File>default.vrs</QPM:File>
                           <QPM:File>frodo.vpl</QPM:File>
                           <QPM:File>godot.vpl</QPM:File>
                           <QPM:File>kernal</QPM:File>
                           <QPM:File>kernal64</QPM:File>
                           <QPM:File>kernalde</QPM:File>
                           <QPM:File>kernalfi</QPM:File>
                           <QPM:File>kernalfr</QPM:File>
                           <QPM:File>kernalit</QPM:File>
                           <QPM:File>kernalno</QPM:File>
                           <QPM:File>kernalse</QPM:File>
                           <QPM:File>pc64.vpl</QPM:File>
                           <QPM:File>vdc_deft.vpl</QPM:File>
                           <QPM:File>vice.vpl</QPM:File>
                           <QPM:File>x11_pos.vkm</QPM:File>
                           <QPM:File>x11_sym.vkm</QPM:File>
                        </QPM:Dir>

                        <QPM:Dir name="C64">
                           <QPM:File>basic</QPM:File>
                           <QPM:File>c64hq.vpl</QPM:File>
                           <QPM:File>c64mem.sym</QPM:File>
                           <QPM:File>c64s.vpl</QPM:File>
                           <QPM:File>ccs64.vpl</QPM:File>
                           <QPM:File>chargen</QPM:File>
                           <QPM:File>default.vpl</QPM:File>
                           <QPM:File>default.vrs</QPM:File>
                           <QPM:File>frodo.vpl</QPM:File>
                           <QPM:File>godot.vpl</QPM:File>
                           <QPM:File>kernal</QPM:File>
                           <QPM:File>pc64.vpl</QPM:File>
                           <QPM:File>vice.vpl</QPM:File>
                           <QPM:File>x11_pos.vkm</QPM:File>
                           <QPM:File>x11_sym.vkm</QPM:File>
                        </QPM:Dir>

                        <QPM:Dir name="C64DTV">
                           <QPM:File>basic</QPM:File>
                           <QPM:File>c64hq.vpl</QPM:File>
                           <QPM:File>c64mem.sym</QPM:File>
                           <QPM:File>c64s.vpl</QPM:File>
                           <QPM:File>ccs64.vpl</QPM:File>
                           <QPM:File>chargen</QPM:File>
                           <QPM:File>default.vpl</QPM:File>
                           <QPM:File>default.vrs</QPM:File>
_END

if test x"$DTVROM_INSTALL" = "xyes"; then
  echo >manifest.16 "                           <QPM:File>dtvrom.bin</QPM:File>"
fi

  cat >manifest.17 <<_END
                           <QPM:File>frodo.vpl</QPM:File>
                           <QPM:File>godot.vpl</QPM:File>
                           <QPM:File>kernal</QPM:File>
                           <QPM:File>pc64.vpl</QPM:File>
                           <QPM:File>vice.vpl</QPM:File>
                           <QPM:File>x11_pos.vkm</QPM:File>
                           <QPM:File>x11_sym.vkm</QPM:File>
                        </QPM:Dir>

                        <QPM:Dir name="CBM-II">
                           <QPM:File>amber.vpl</QPM:File>
                           <QPM:File>basic.128</QPM:File>
                           <QPM:File>basic.256</QPM:File>
                           <QPM:File>basic.500</QPM:File>
                           <QPM:File>c64hq.vpl</QPM:File>
                           <QPM:File>c64s.vpl</QPM:File>
                           <QPM:File>ccs64.vpl</QPM:File>
                           <QPM:File>chargen.500</QPM:File>
                           <QPM:File>chargen.600</QPM:File>
                           <QPM:File>chargen.700</QPM:File>
                           <QPM:File>default.vpl</QPM:File>
                           <QPM:File>frodo.vpl</QPM:File>
                           <QPM:File>godot.vpl</QPM:File>
                           <QPM:File>green.vpl</QPM:File>
                           <QPM:File>kernal</QPM:File>
                           <QPM:File>kernal.500</QPM:File>
                           <QPM:File>pc64.vpl</QPM:File>
                           <QPM:File>rom128h.vrs</QPM:File>
                           <QPM:File>rom128l.vrs</QPM:File>
                           <QPM:File>rom256h.vrs</QPM:File>
                           <QPM:File>rom256l.vrs</QPM:File>
                           <QPM:File>rom500.vrs</QPM:File>
                           <QPM:File>white.vpl</QPM:File>
                           <QPM:File>x11_buks.vkm</QPM:File>
                        </QPM:Dir>

                        <QPM:Dir name="DRIVES">
                           <QPM:File>d1541II</QPM:File>
                           <QPM:File>d1571cr</QPM:File>
                           <QPM:File>dos1001</QPM:File>
                           <QPM:File>dos1541</QPM:File>
                           <QPM:File>dos1551</QPM:File>
                           <QPM:File>dos1570</QPM:File>
                           <QPM:File>dos1571</QPM:File>
                           <QPM:File>dos1581</QPM:File>
                           <QPM:File>dos2031</QPM:File>
                           <QPM:File>dos2040</QPM:File>
                           <QPM:File>dos3040</QPM:File>
                           <QPM:File>dos4040</QPM:File>
                        </QPM:Dir>

                        <QPM:Dir name="PET">
                           <QPM:File>amber.vpl</QPM:File>
                           <QPM:File>basic1</QPM:File>
                           <QPM:File>basic2</QPM:File>
                           <QPM:File>basic4</QPM:File>
                           <QPM:File>chargen</QPM:File>
                           <QPM:File>chargen.de</QPM:File>
                           <QPM:File>edit1g</QPM:File>
                           <QPM:File>edit2b</QPM:File>
                           <QPM:File>edit2g</QPM:File>
                           <QPM:File>edit4b40</QPM:File>
                           <QPM:File>edit4b80</QPM:File>
                           <QPM:File>edit4g40</QPM:File>
                           <QPM:File>green.vpl</QPM:File>
                           <QPM:File>kernal1</QPM:File>
                           <QPM:File>kernal2</QPM:File>
                           <QPM:File>kernal4</QPM:File>
                           <QPM:File>rom1g.vrs</QPM:File>
                           <QPM:File>rom2b.vrs</QPM:File>
                           <QPM:File>rom2g.vrs</QPM:File>
                           <QPM:File>rom4b40.vrs</QPM:File>
                           <QPM:File>rom4b80.vrs</QPM:File>
                           <QPM:File>rom4g40.vrs</QPM:File>
                           <QPM:File>white.vpl</QPM:File>
                           <QPM:File>x11_bdep.vkm</QPM:File>
                           <QPM:File>x11_bdes.vkm</QPM:File>
                           <QPM:File>x11_bgrs.vkm</QPM:File>
                           <QPM:File>x11_buks.vkm</QPM:File>
                        </QPM:Dir>

                        <QPM:Dir name="PLUS4">
                           <QPM:File>3plus1hi</QPM:File>
                           <QPM:File>3plus1lo</QPM:File>
                           <QPM:File>basic</QPM:File>
                           <QPM:File>default.vpl</QPM:File>
                           <QPM:File>default.vrs</QPM:File>
                           <QPM:File>kernal</QPM:File>
                           <QPM:File>vice.vpl</QPM:File>
                           <QPM:File>x11_pos.vkm</QPM:File>
                           <QPM:File>x11_sym.vkm</QPM:File>
                        </QPM:Dir>

                        <QPM:Dir name="PRINTER">
                           <QPM:File>cbm1526</QPM:File>
                           <QPM:File>mps801</QPM:File>
                           <QPM:File>mps803</QPM:File>
                           <QPM:File>mps803.vpl</QPM:File>
                           <QPM:File>nl10-cbm</QPM:File>
                        </QPM:Dir>

                        <QPM:Dir name="VIC20">
                           <QPM:File>basic</QPM:File>
                           <QPM:File>chargen</QPM:File>
                           <QPM:File>default.vpl</QPM:File>
                           <QPM:File>default.vrs</QPM:File>
                           <QPM:File>kernal</QPM:File>
                           <QPM:File>x11_pos.vkm</QPM:File>
                           <QPM:File>x11_sym.vkm</QPM:File>
                        </QPM:Dir>

                        <QPM:Dir name="doc">
                           <QPM:File>64doc.txt</QPM:File>
                           <QPM:File>BUGS</QPM:File>
                           <QPM:File>COPYING</QPM:File>
                           <QPM:File>MSDOS-Ethernet-Howto.txt</QPM:File>
                           <QPM:File>MSDOS-Howto.txt</QPM:File>
                           <QPM:File>MinixVmd-Howto.txt</QPM:File>
                           <QPM:File>NEWS</QPM:File>
                           <QPM:File>NLS-Howto.txt</QPM:File>
                           <QPM:File>PETdoc.txt</QPM:File>
                           <QPM:File>Readme.beos</QPM:File>
                           <QPM:File>Readme.dos</QPM:File>
                           <QPM:File>Readme.x64dtv</QPM:File>
                           <QPM:File>ReadmeMacOSX.txt</QPM:File>
                           <QPM:File>TODO</QPM:File>
                           <QPM:File>Walkthrough-Howto.txt</QPM:File>
                           <QPM:File>Win32-Howto.txt</QPM:File>
                           <QPM:File>cbm_basic_tokens.txt</QPM:File>
                           <QPM:File>drive_info.txt</QPM:File>
                           <QPM:File>iec-bus.txt</QPM:File>
                           <QPM:File>index.html</QPM:File>
                           <QPM:File>mon.txt</QPM:File>
                           <QPM:File>new.gif</QPM:File>
                           <QPM:File>serial.txt</QPM:File>
                           <QPM:File>vice-logo.jpg</QPM:File>
                           <QPM:File>vice_1.html</QPM:File>
                           <QPM:File>vice_10.html</QPM:File>
                           <QPM:File>vice_11.html</QPM:File>
                           <QPM:File>vice_12.html</QPM:File>
                           <QPM:File>vice_13.html</QPM:File>
                           <QPM:File>vice_14.html</QPM:File>
                           <QPM:File>vice_15.html</QPM:File>
                           <QPM:File>vice_16.html</QPM:File>
                           <QPM:File>vice_2.html</QPM:File>
                           <QPM:File>vice_3.html</QPM:File>
                           <QPM:File>vice_4.html</QPM:File>
                           <QPM:File>vice_5.html</QPM:File>
                           <QPM:File>vice_6.html</QPM:File>
                           <QPM:File>vice_7.html</QPM:File>
                           <QPM:File>vice_8.html</QPM:File>
                           <QPM:File>vice_9.html</QPM:File>
                           <QPM:File>vice_toc.html</QPM:File>
                        </QPM:Dir>

                        <QPM:Dir name="fonts">
                           <QPM:File>fonts.dir</QPM:File>
                           <QPM:File>vice-cbm.pcf</QPM:File>
                        </QPM:Dir>
                     </QPM:Dir>
                  </QPM:Dir>

                  <QPM:Dir name="man">
                     <QPM:Dir name="man1">
                        <QPM:File>c1541.1</QPM:File>
                        <QPM:File>petcat.1</QPM:File>
                        <QPM:File>vice.1</QPM:File>
                     </QPM:Dir>
                  </QPM:Dir>
               </QPM:Dir>

               <QPM:Dir name="usr">
                  <QPM:Union link="../opt/info">info</QPM:Union>
                  <QPM:Union link="../opt/bin">bin</QPM:Union>
                  <QPM:Union link="../\$(PROCESSOR)/opt/bin">bin</QPM:Union>
                  <QPM:Dir name="lib">
                     <QPM:Dir name="locale">
                        <QPM:Dir name="de">
                           <QPM:Union link="../../../../opt/lib/locale/de/LC_MESSAGES">LC_MESSAGES</QPM:Union>
                        </QPM:Dir>

                        <QPM:Dir name="fr">
                           <QPM:Union link="../../../../opt/lib/locale/fr/LC_MESSAGES">LC_MESSAGES</QPM:Union>
                        </QPM:Dir>

                        <QPM:Dir name="hu">
                           <QPM:Union link="../../../../opt/lib/locale/hu/LC_MESSAGES">LC_MESSAGES</QPM:Union>
                        </QPM:Dir>

                        <QPM:Dir name="it">
                           <QPM:Union link="../../../../opt/lib/locale/it/LC_MESSAGES">LC_MESSAGES</QPM:Union>
                        </QPM:Dir>

                        <QPM:Dir name="nl">
                           <QPM:Union link="../../../../opt/lib/locale/nl/LC_MESSAGES">LC_MESSAGES</QPM:Union>
                        </QPM:Dir>

                        <QPM:Dir name="pl">
                           <QPM:Union link="../../../../opt/lib/locale/pl/LC_MESSAGES">LC_MESSAGES</QPM:Union>
                        </QPM:Dir>

                        <QPM:Dir name="sv">
                           <QPM:Union link="../../../../opt/lib/locale/sv/LC_MESSAGES">LC_MESSAGES</QPM:Union>
                        </QPM:Dir>
                     </QPM:Dir>

                     <QPM:Dir name="vice">
                        <QPM:Union link="../../../opt/lib/vice/fonts">fonts</QPM:Union>
                        <QPM:Union link="../../../opt/lib/vice/doc">doc</QPM:Union>
                        <QPM:Union link="../../../opt/lib/vice/VIC20">VIC20</QPM:Union>
                        <QPM:Union link="../../../opt/lib/vice/PRINTER">PRINTER</QPM:Union>
                        <QPM:Union link="../../../opt/lib/vice/PLUS4">PLUS4</QPM:Union>
                        <QPM:Union link="../../../opt/lib/vice/PET">PET</QPM:Union>
                        <QPM:Union link="../../../opt/lib/vice/DRIVES">DRIVES</QPM:Union>
                        <QPM:Union link="../../../opt/lib/vice/CBM-II">CBM-II</QPM:Union>
                        <QPM:Union link="../../../opt/lib/vice/C64DTV">C64DTV</QPM:Union>
                        <QPM:Union link="../../../opt/lib/vice/C64">C64</QPM:Union>
                        <QPM:Union link="../../../opt/lib/vice/C128">C128</QPM:Union>
                     </QPM:Dir>
                  </QPM:Dir>

                  <QPM:Dir name="man">
                     <QPM:Union link="../../opt/man/man1">man1</QPM:Union>
                  </QPM:Dir>
               </QPM:Dir>
            </QPM:Dir>
         </QPM:Listing>
      </QPM:FileManifest>

      <QPM:Launch name="x64">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/x64"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="x64 (no sound)">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/x64 -sounddev dummy"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="x64dtv">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/x64dtv"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="x64dtv (no sound)">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/x64dtv -sounddev dummy"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="x128">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/x128"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="x128 (no sound)">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/x128 -sounddev dummy"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="xvic">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/xvic"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="xvic (no sound)">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/xvic -sounddev dummy"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="xpet">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/xpet"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="xpet (no sound)">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/xpet -sounddev dummy"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="xplus4">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/xplus4"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="xplus4 (no sound)">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/xplus4 -sounddev dummy"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="xcbm2">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/xcbm2"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>

      <QPM:Launch name="xcbm2 (no sound)">
         <QPM:String name="Topic" value="Applications/Emulators"/>
         <QPM:String name="Command" value="/opt/bin/xcbm2 -sounddev dummy"/>
         <QPM:String name="Icon" value="/usr/share/icons/topics/chameleon.gif"/>
      </QPM:Launch>
   </RDF:Description>
</RDF:RDF>
_END

  cat >public/$DTV_NAME/core-$QNXVER/MANIFEST manifest.01 manifest.02 manifest.03 \
      manifest.04 manifest.05 manifest.06 manifest.07 manifest.08 manifest.09 \
      manifest.10 manifest.11 manifest.12 manifest.14 manifest.15 manifest.16 \
      manifest.17

  tar cf $DTV_NAME-core.tar public
  gzip $DTV_NAME-core.tar
  mv $DTV_NAME-core.tar.gz $QNXPORT-public.qpk

  ls -l -R $QNXPORT-public.qpk >size.tmp
  manifest_size=`./getsize size.tmp` 
  rm -f -r size.tmp

  echo >manifest.04 "            <QPM:PackageSize>$manifest_size</QPM:PackageSize>"

  cat >$QNXPORT-public.qpm manifest.01 manifest.02 manifest.03 manifest.04 \
      manifest.05 manifest.06 manifest.07 manifest.08 manifest.09 manifest.10 \
      manifest.11 manifest.12 manifest.14 manifest.15 manifest.16 manifest.17

  rm -f -r public

  tar cf $DTV_NAME-x86.tar $QNXPORT-public.qp? $QNXPORT-public.repdata $QNXPORT-x86-public.qp?
  gzip $DTV_NAME-x86.tar
  mv $DTV_NAME-x86.tar.gz $QNXPORT-x86-public.qpr

  rm -f -r *.qpk *.qpm *.repdata manifest.* $QNXPORT

  echo QNX port binary package part generated as $QNXPORT-x86-public.qpr
else
  echo QNX port binary distribution directory generated as $QNXPORT
fi
