#!/bin/sh
# make-bindist.sh for the SOLARIS ports
#
# written by Marco van den Heuvel <blackystardust68@yahoo.com>
#
# make-bindist.sh <strip> <vice-version> <dtv-name> <dtv-revision> <prefix> <cross> <zip|nozip> <topsrcdir> <release> <release-number>
#                 $1      $2             $3         $4             $5       $6      $7          $8          $9        $10

STRIP=$1
VICE_VERSION=$2
DTV_NAME=$3
DTV_REVISION=$4
PREFIX=$5
CROSS=$6
ZIPKIND=$7
TOP_SRC_DIR=$8
RELEASE=$9

shift
RELEASE_NUMBER=$9

if test x"$PREFIX" != "x/usr/local"; then
  echo Error: installation path is not /usr/local
  exit 1
fi

if test x"$CROSS" = "xtrue"; then
  echo Error: make bindist for SOLARIS can only be done on SOLARIS
  exit 1
fi

if [ ! -e /usr/local/bin/x64 -o ! -e /usr/local/bin/x64dtv -o ! -e /usr/local/bin/x128 -o ! -e /usr/local/bin/xvic -o ! -e /usr/local/bin/xpet -o ! -e /usr/local/bin/xplus4 -o ! -e /usr/local/bin/xcbm2 -o ! -e /usr/local/bin/c1541 -o ! -e /usr/local/bin/petcat -o ! -e /usr/local/bin/cartconv ]
then
  echo Error: \"make install\" needs to be done first
  exit 1
fi

if test x"$RELEASE" = "xyes"; then
  SOLPORT=$DTV_NAME-$RELEASE_NUMBER-$VICE_VERSION
  SOLVER=$RELEASE_NUMBER-$VICE_VERSION
else
  SOLPORT=$DTV_NAME-$VICE_VERSION-$DTV_REVISION
  SOLVER=$VICE_VERSION-$DTV_REVISION
fi

echo Generating SOLARIS port binary distribution.
rm -f -r $SOLPORT
mkdir $SOLPORT
mkdir -p $SOLPORT/usr/local
mkdir -p $SOLPORT/usr/local/lib/locale/de/LC_MESSAGES
mv /usr/local/lib/locale/de/LC_MESSAGES/$DTV_NAME.* $SOLPORT/usr/local/lib/locale/de/LC_MESSAGES
mkdir -p $SOLPORT/usr/local/lib/locale/fr/LC_MESSAGES
mv /usr/local/lib/locale/fr/LC_MESSAGES/$DTV_NAME.* $SOLPORT/usr/local/lib/locale/fr/LC_MESSAGES
mkdir -p $SOLPORT/usr/local/lib/locale/it/LC_MESSAGES
mv /usr/local/lib/locale/it/LC_MESSAGES/$DTV_NAME.* $SOLPORT/usr/local/lib/locale/it/LC_MESSAGES
mkdir -p $SOLPORT/usr/local/lib/locale/sv/LC_MESSAGES
mv /usr/local/lib/locale/sv/LC_MESSAGES/$DTV_NAME.* $SOLPORT/usr/local/lib/locale/sv/LC_MESSAGES
mkdir -p $SOLPORT/usr/local/lib/locale/pl/LC_MESSAGES
mv /usr/local/lib/locale/pl/LC_MESSAGES/$DTV_NAME.* $SOLPORT/usr/local/lib/locale/pl/LC_MESSAGES
mkdir -p $SOLPORT/usr/local/lib/locale/nl/LC_MESSAGES
mv /usr/local/lib/locale/nl/LC_MESSAGES/$DTV_NAME.* $SOLPORT/usr/local/lib/locale/nl/LC_MESSAGES
mkdir -p $SOLPORT/usr/local/lib/locale/hu/LC_MESSAGES
mv /usr/local/lib/locale/hu/LC_MESSAGES/$DTV_NAME.* $SOLPORT/usr/local/lib/locale/hu/LC_MESSAGES
mkdir $SOLPORT/usr/local/bin
mv /usr/local/bin/vsid $SOLPORT/usr/local/bin
mv /usr/local/bin/x64 $SOLPORT/usr/local/bin
$STRIP $SOLPORT/usr/local/bin/x64
mv /usr/local/bin/x64dtv $SOLPORT/usr/local/bin
$STRIP $SOLPORT/usr/local/bin/x64dtv
mv /usr/local/bin/x128 $SOLPORT/usr/local/bin
$STRIP $SOLPORT/usr/local/bin/x128
mv /usr/local/bin/xvic $SOLPORT/usr/local/bin
$STRIP $SOLPORT/usr/local/bin/xvic
mv /usr/local/bin/xpet $SOLPORT/usr/local/bin
$STRIP $SOLPORT/usr/local/bin/xpet
mv /usr/local/bin/xplus4 $SOLPORT/usr/local/bin
$STRIP $SOLPORT/usr/local/bin/xplus4
mv /usr/local/bin/xcbm2 $SOLPORT/usr/local/bin
$STRIP $SOLPORT/usr/local/bin/xcbm2
mv /usr/local/bin/c1541 $SOLPORT/usr/local/bin
$STRIP $SOLPORT/usr/local/bin/c1541
mv /usr/local/bin/petcat $SOLPORT/usr/local/bin
$STRIP $SOLPORT/usr/local/bin/petcat
mv /usr/local/bin/cartconv $SOLPORT/usr/local/bin
$STRIP $SOLPORT/usr/local/bin/cartconv
mv /usr/local/lib/vice $SOLPORT/usr/local/lib
rm `find $SOLPORT -name "amiga_*.vkm"`
rm `find $SOLPORT -name "beos_*.vkm"`
rm `find $SOLPORT -name "dos_*.vkm"`
rm `find $SOLPORT -name "os2*.vkm"`
rm `find $SOLPORT -name "osx*.vkm"`
rm `find $SOLPORT -name "win_*.vkm"`
rm `find $SOLPORT -name "RO*.vkm"`
mkdir -p $SOLPORT/usr/local/man/man1
mv /usr/local/man/man1/c1541.1 $SOLPORT/usr/local/man/man1
mv /usr/local/man/man1/petcat.1 $SOLPORT/usr/local/man/man1
mv /usr/local/man/man1/vice.1 $SOLPORT/usr/local/man/man1
mkdir $SOLPORT/usr/local/info
mv /usr/local/info/vice.info* $SOLPORT/usr/local/info
if test x"$ZIPKIND" = "xzip"; then
  rm -f -r /var/spool/pkg/UMC$DTV_NAME
  gcc $TOP_SRC_DIR/src/arch/unix/solaris/convertprototype.c -o ./convertprototype

  currentdir=`pwd`

  cd $SOLPORT/usr/local
  find . -print | pkgproto >prototype.tmp
  echo >prototype "i pkginfo=./pkginfo"
  $currentdir/convertprototype prototype.tmp >>prototype

  arch_cpu=`uname -m`
  if test x"$arch_cpu" = "xi86pc"; then
    arch_cpu=x86
  else
    arch_cpu=sparc
  fi

  arch_version=`uname -r`

  if test x"$arch_version" = "x5.6"; then
    arch_version=sol26
  fi

  if test x"$arch_version" = "x5.7"; then
    arch_version=sol7
  fi

  if test x"$arch_version" = "x5.8"; then
    arch_version=sol8
  fi

  if test x"$arch_version" = "x5.9"; then
    arch_version=sol9
  fi

  if test x"$arch_version" = "x5.10"; then
    arch_version=sol10
  fi


  cat >pkginfo <<_END
PKG="UMC$DTV_NAME"
NAME="$DTV_NAME"
ARCH="$arch_cpu"
VERSION="$SOLVER"
CATEGORY="emulator"
VENDOR="The VICEplus Team"
EMAIL="viceplusteam@yahoo.com"
PSTAMP="Marco van den Heuvel"
BASEDIR="/usr/local"
CLASSES="none"
_END

  packagename=$SOLPORT-$arch_version-$arch_cpu-local

  echo >$currentdir/input.txt all

  pkgmk -r `pwd`
  rm -f -r prototype.tmp
  cd /var/spool/pkg
  pkgtrans -s `pwd` /tmp/$packagename <$currentdir/input.txt
  gzip /tmp/$packagename
  cd $currentdir
  mv /tmp/$packagename.gz ./
  rm -f -r $SOLPORT convertprototype $currentdir/input.txt

  echo SOLARIS port binary package generated as $packagename.gz
else
  echo SOLARIS port binary distribution directory generated as $SOLPORT
fi
