#!/bin/sh
# make-bindist.sh for the WIN32 port
#
# written by Marco van den Heuvel <blackystardust68@yahoo.com>
#
# make-bindist.sh <strip> <vice-version> <dtv-name> <dtv-revision> <zip|nozip> <top-srcdir> <release> <release-number>
#                 $1      $2             $3         $4             $5          $6           $7        $8

STRIP=$1
VICE_VERSION=$2
DTV_NAME=$3
DTV_REVISION=$4
ZIPKIND=$5
TOP_SRC_DIR=$6
RELEASE=$7
RELEASE_NUMBER=$8

if [ ! -e src/x64.exe -o ! -e src/x64dtv.exe -o ! -e src/x128.exe -o ! -e src/xvic.exe -o ! -e src/xpet.exe -o ! -e src/xplus4.exe -o ! -e src/xcbm2.exe -o ! -e src/c1541.exe -o ! -e src/petcat.exe -o ! -e src/cartconv.exe ]
then
  echo Error: executable file\(s\) not found, do a \"make\" first
  exit 1
fi

if test x"$RELEASE" = "xyes"; then
  WIN32PORT=Win$DTV_NAME-$RELEASE_NUMBER-$VICE_VERSION
else
  WIN32PORT=Win$DTV_NAME-$VICE_VERSION-$DTV_REVISION
fi

echo Generating WIN32 port binary distribution.
rm -f -r $WIN32PORT
mkdir $WIN32PORT
$STRIP src/x64.exe
$STRIP src/x64dtv.exe
$STRIP src/x128.exe
$STRIP src/xvic.exe
$STRIP src/xpet.exe
$STRIP src/xplus4.exe
$STRIP src/xcbm2.exe
$STRIP src/c1541.exe
$STRIP src/petcat.exe
$STRIP src/cartconv.exe
cp src/x64.exe src/x64dtv.exe src/x128.exe src/xvic.exe $WIN32PORT
cp src/xpet.exe src/xplus4.exe src/xcbm2.exe $WIN32PORT
cp src/c1541.exe src/petcat.exe src/cartconv.exe $WIN32PORT
cp -a $TOP_SRC_DIR/data/C128 $TOP_SRC_DIR/data/C64 $TOP_SRC_DIR/data/C64DTV $TOP_SRC_DIR/data/CBM-II $TOP_SRC_DIR/data/DRIVES $WIN32PORT
cp -a $TOP_SRC_DIR/data/PET $TOP_SRC_DIR/data/PLUS4 $TOP_SRC_DIR/data/PRINTER $TOP_SRC_DIR/data/VIC20 $WIN32PORT
cp -a data/C128 data/C64 data/C64DTV data/CBM-II data/DRIVES $WIN32PORT
cp -a data/PET data/PLUS4 data/PRINTER data/VIC20 $WIN32PORT
cp -a $TOP_SRC_DIR/data/fonts $WIN32PORT
cp -a $TOP_SRC_DIR/doc/html $WIN32PORT
cp $TOP_SRC_DIR/FEEDBACK $TOP_SRC_DIR/README $WIN32PORT
cp $TOP_SRC_DIR/doc/cartconv.txt $WIN32PORT
cp $TOP_SRC_DIR/doc/Readme.x64dtv $WIN32PORT
rm `find $WIN32PORT -name "Makefile*"`
rm `find $WIN32PORT -name "amiga_*.vkm"`
rm `find $WIN32PORT -name "dos_*.vkm"`
rm `find $WIN32PORT -name "os2*.vkm"`
rm `find $WIN32PORT -name "osx*.vkm"`
rm `find $WIN32PORT -name "beos_*.vkm"`
rm `find $WIN32PORT -name "x11_*.vkm"`
rm `find $WIN32PORT -name "RO*.vkm"`
rm $WIN32PORT/html/texi2html
if test x"$ZIPKIND" = "xzip"; then
  if test x"$ZIP" = "x"; then
    zip -r -9 -q $WIN32PORT.zip $WIN32PORT
  else
    $ZIP $WIN32PORT.zip $WIN32PORT
  fi
  rm -f -r $WIN32PORT
  echo WIN32 port binary distribution archive generated as $WIN32PORT.zip
else
  echo WIN32 port binary distribution directory generated as $WIN32PORT
fi
