/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.sql.SQLException;
import org.postgresql.Connection;
import org.postgresql.ResultSet;
import org.postgresql.util.PSQLException;

public class Field {
    public int length;
    public int oid;
    public int mod;
    public String name;
    protected Connection conn;
    public int sql_type = -1;
    public String type_name = null;
    private static final String[] types = new String[]{"int2", "int4", "oid", "int8", "cash", "money", "numeric", "float4", "float8", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar", "text", "name", "filename", "bool", "date", "time", "abstime", "timestamp"};
    private static final int[] typei = new int[]{5, 4, 4, -5, 8, 8, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -7, 91, 92, 93, 93};

    public Field(Connection connection, String string, int n, int n2) {
        this(connection, string, n, n2, 0);
    }

    public Field(Connection connection, String string, int n, int n2, int n3) {
        this.conn = connection;
        this.name = string;
        this.oid = n;
        this.length = n2;
        this.mod = n3;
    }

    public int getOID() {
        return this.oid;
    }

    public int getSQLType() throws SQLException {
        if (this.sql_type == -1) {
            this.type_name = (String)this.conn.fieldCache.get(new Integer(this.oid));
            if (this.type_name == null) {
                ResultSet resultSet = (ResultSet)((Object)this.conn.ExecSQL("select typname from pg_type where oid = " + this.oid));
                if (resultSet.getColumnCount() != 1 || resultSet.getTupleCount() != 1) {
                    throw new PSQLException("postgresql.unexpected");
                }
                resultSet.next();
                this.type_name = resultSet.getString(1);
                this.conn.fieldCache.put(new Integer(this.oid), this.type_name);
                resultSet.close();
            }
            this.sql_type = Field.getSQLType(this.type_name);
        }
        return this.sql_type;
    }

    public static int getSQLType(String string) {
        int n = 1111;
        int n2 = 0;
        while (n2 < types.length) {
            if (string.equals(types[n2])) {
                n = typei[n2];
            }
            ++n2;
        }
        return n;
    }

    public String getTypeName() throws SQLException {
        int n = this.getSQLType();
        return this.type_name;
    }
}

