/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.channel;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.Mentionable;
import org.javacord.api.entity.channel.Categorizable;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.RegularServerChannel;
import org.javacord.api.entity.channel.ServerChannelUpdater;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.channel.TextableRegularServerChannelUpdater;
import org.javacord.api.entity.permission.PermissionType;
import org.javacord.api.entity.user.User;
import org.javacord.api.entity.webhook.WebhookBuilder;
import org.javacord.api.listener.channel.server.textable.TextableRegularServerChannelAttachableListenerManager;

public interface TextableRegularServerChannel
extends TextChannel,
RegularServerChannel,
TextableRegularServerChannelAttachableListenerManager,
Mentionable,
Categorizable {
    @Override
    default public boolean canWrite(User user) {
        return this.asRegularServerChannel().map(regularServerChannel -> regularServerChannel.hasPermission(user, PermissionType.ADMINISTRATOR) || regularServerChannel.hasPermissions(user, PermissionType.VIEW_CHANNEL, PermissionType.SEND_MESSAGES)).orElse(false);
    }

    @Override
    default public boolean canUseExternalEmojis(User user) {
        if (!this.canWrite(user)) {
            return false;
        }
        return this.asRegularServerChannel().map(regularServerChannel -> regularServerChannel.hasAnyPermission(user, PermissionType.ADMINISTRATOR, PermissionType.USE_EXTERNAL_EMOJIS)).orElse(false);
    }

    @Override
    default public boolean canEmbedLinks(User user) {
        if (!this.canWrite(user)) {
            return false;
        }
        return this.asRegularServerChannel().map(regularServerChannel -> regularServerChannel.hasAnyPermission(user, PermissionType.ADMINISTRATOR, PermissionType.EMBED_LINKS)).orElse(false);
    }

    @Override
    default public boolean canReadMessageHistory(User user) {
        if (!this.canSee(user)) {
            return false;
        }
        return this.asRegularServerChannel().map(regularServerChannel -> regularServerChannel.hasAnyPermission(user, PermissionType.ADMINISTRATOR, PermissionType.READ_MESSAGE_HISTORY)).orElse(false);
    }

    @Override
    default public boolean canUseTts(User user) {
        if (!this.canWrite(user)) {
            return false;
        }
        return this.asRegularServerChannel().map(regularServerChannel -> regularServerChannel.hasAnyPermission(user, PermissionType.ADMINISTRATOR, PermissionType.READ_MESSAGE_HISTORY)).orElse(false);
    }

    @Override
    default public boolean canAttachFiles(User user) {
        return this.asRegularServerChannel().map(regularServerChannel -> regularServerChannel.hasPermission(user, PermissionType.ADMINISTRATOR) || regularServerChannel.hasPermission(user, PermissionType.ATTACH_FILES) && this.canWrite(user)).orElse(false);
    }

    @Override
    default public boolean canAddNewReactions(User user) {
        return this.asRegularServerChannel().map(regularServerChannel -> regularServerChannel.hasPermission(user, PermissionType.ADMINISTRATOR) || regularServerChannel.hasPermissions(user, PermissionType.VIEW_CHANNEL, PermissionType.READ_MESSAGE_HISTORY, PermissionType.ADD_REACTIONS)).orElse(false);
    }

    @Override
    default public boolean canManageMessages(User user) {
        if (!this.canSee(user)) {
            return false;
        }
        return this.asRegularServerChannel().map(regularServerChannel -> regularServerChannel.hasAnyPermission(user, PermissionType.ADMINISTRATOR, PermissionType.MANAGE_MESSAGES)).orElse(false);
    }

    @Override
    default public boolean canMentionEveryone(User user) {
        if (!this.canSee(user)) {
            return false;
        }
        return this.asRegularServerChannel().map(regularServerChannel -> regularServerChannel.hasPermission(user, PermissionType.ADMINISTRATOR) || regularServerChannel.hasPermission(user, PermissionType.MENTION_EVERYONE) && this.canWrite(user)).orElse(false);
    }

    @Override
    default public TextableRegularServerChannelUpdater createUpdater() {
        return new TextableRegularServerChannelUpdater(this);
    }

    public boolean isNsfw();

    default public CompletableFuture<Void> updateNsfw(boolean nsfw) {
        return ((ServerChannelUpdater)this.createUpdater().setNsfw(nsfw)).update();
    }

    public int getSlowmodeDelayInSeconds();

    default public boolean hasSlowmode() {
        return this.getSlowmodeDelayInSeconds() != 0;
    }

    default public CompletableFuture<Void> updateSlowmodeDelayInSeconds(int delay) {
        return ((ServerChannelUpdater)this.createUpdater().setSlowmodeDelayInSeconds(delay)).update();
    }

    default public CompletableFuture<Void> unsetSlowmode() {
        return ((ServerChannelUpdater)this.createUpdater().unsetSlowmode()).update();
    }

    @Override
    default public CompletableFuture<Void> updateCategory(ChannelCategory category) {
        return ((ServerChannelUpdater)this.createUpdater().setCategory(category)).update();
    }

    @Override
    default public CompletableFuture<Void> removeCategory() {
        return ((ServerChannelUpdater)this.createUpdater().removeCategory()).update();
    }

    default public Optional<? extends TextableRegularServerChannel> getCurrentCachedInstance() {
        return this.getApi().getTextableRegularServerChannelById(this.getId());
    }

    @Override
    default public CompletableFuture<? extends TextableRegularServerChannel> getLatestInstance() {
        Optional<? extends TextableRegularServerChannel> currentCachedInstance = this.getCurrentCachedInstance();
        if (currentCachedInstance.isPresent()) {
            return CompletableFuture.completedFuture(currentCachedInstance.get());
        }
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(new NoSuchElementException());
        return result;
    }

    @Override
    default public String getMentionTag() {
        return "<#" + this.getIdAsString() + ">";
    }

    default public WebhookBuilder createWebhookBuilder() {
        return new WebhookBuilder(this);
    }
}

