/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.message;

public enum MessageType {
    NORMAL(0),
    NORMAL_WEBHOOK(0),
    RECIPIENT_ADD(1),
    RECIPIENT_REMOVE(2),
    CALL(3),
    CHANNEL_NAME_CHANGE(4),
    CHANNEL_ICON_CHANGE(5),
    CHANNEL_PINNED_MESSAGE(6),
    SERVER_MEMBER_JOIN(7),
    USER_PREMIUM_SERVER_SUBSCRIPTION(8),
    USER_PREMIUM_SERVER_SUBSCRIPTION_TIER_1(9),
    USER_PREMIUM_SERVER_SUBSCRIPTION_TIER_2(10),
    USER_PREMIUM_SERVER_SUBSCRIPTION_TIER_3(11),
    CHANNEL_FOLLOW_ADD(12),
    SERVER_DISCOVERY_DISQUALIFIED(14),
    SERVER_DISCOVERY_REQUALIFIED(15),
    SERVER_DISCOVERY_GRACE_PERIOD_INITIAL_WARNING(16),
    SERVER_DISCOVERY_GRACE_PERIOD_FINAL_WARNING(17),
    THREAD_CREATED(18),
    REPLY(19),
    SLASH_COMMAND(20),
    THREAD_STARTER_MESSAGE(21),
    GUILD_INVITE_REMINDER(22),
    CONTEXT_MENU_COMMAND(23),
    AUTO_MODERATION_ACTION(24),
    ROLE_SUBSCRIPTION_PURCHASE(25),
    INTERACTION_PREMIUM_UPSELL(26),
    STAGE_START(27),
    STAGE_END(28),
    STAGE_SPEAKER_JOIN(29),
    STAGE_TOPIC_CHANGE(31),
    SERVER_APPLICATION_PREMIUM_SUBSCRIPTION(32),
    UNKNOWN(-1);

    private final int type;

    private MessageType(int type) {
        this.type = type;
    }

    public static MessageType byType(int type, boolean webhook) {
        if (type == 0 && webhook) {
            return NORMAL_WEBHOOK;
        }
        for (MessageType value : MessageType.values()) {
            if (value.type != type) continue;
            return value;
        }
        return UNKNOWN;
    }
}

