/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.server.scheduledevent;

import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.channel.RegularServerChannel;
import org.javacord.api.entity.channel.ServerStageVoiceChannel;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventMetadata;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventPrivacyLevel;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventStatus;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventType;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventUpdater;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventUser;
import org.javacord.api.entity.user.User;

public interface ServerScheduledEvent
extends DiscordEntity {
    public long getServerId();

    default public Server getServer() {
        return this.getApi().getServerById(this.getServerId()).orElseThrow(AssertionError::new);
    }

    public Optional<Long> getChannelId();

    default public Optional<RegularServerChannel> getChannel() {
        return this.getChannelId().flatMap(this.getApi()::getRegularServerChannelById);
    }

    public Optional<Long> getCreatorId();

    public String getName();

    public Optional<String> getDescription();

    public Instant getStartTime();

    public Optional<Instant> getEndTime();

    public ServerScheduledEventPrivacyLevel getPrivacyLevel();

    public ServerScheduledEventStatus getStatus();

    public ServerScheduledEventType getEntityType();

    public Optional<Long> getEntityId();

    public Optional<ServerScheduledEventMetadata> getEntityMetadata();

    public Optional<User> getCreator();

    public Optional<Integer> getUserCount();

    public Optional<Icon> getImage();

    public CompletableFuture<Void> delete();

    default public CompletableFuture<Void> startEvent() {
        return new ServerScheduledEventUpdater(this).setEventStatus(ServerScheduledEventStatus.ACTIVE).update();
    }

    default public CompletableFuture<Void> endEvent() {
        return new ServerScheduledEventUpdater(this).setEventStatus(ServerScheduledEventStatus.COMPLETED).update();
    }

    default public CompletableFuture<Void> cancelEvent() {
        return new ServerScheduledEventUpdater(this).setEventStatus(ServerScheduledEventStatus.CANCELED).update();
    }

    default public ServerScheduledEventUpdater createToExternalEventUpdater(String entityMetadataLocation, Instant endTime) {
        return new ServerScheduledEventUpdater(this).setEntityType(ServerScheduledEventType.EXTERNAL).setChannelId(null).setEntityMetadataLocation(entityMetadataLocation).setScheduledEndTime(endTime);
    }

    default public ServerScheduledEventUpdater createToVoiceEventUpdater(ServerVoiceChannel channel) {
        return new ServerScheduledEventUpdater(this).setEntityType(ServerScheduledEventType.VOICE).setEntityMetadataLocation(null).setChannel(channel);
    }

    default public ServerScheduledEventUpdater createToStageEventUpdater(ServerStageVoiceChannel channel) {
        return new ServerScheduledEventUpdater(this).setEntityType(ServerScheduledEventType.STAGE_INSTANCE).setEntityMetadataLocation(null).setChannel(channel);
    }

    public CompletableFuture<Set<ServerScheduledEventUser>> requestParticipants();

    public CompletableFuture<Set<ServerScheduledEventUser>> requestParticipants(Integer var1, Long var2, Long var3);

    public static enum Type {
        VOICE(1),
        STAGE_INSTANCE(2),
        EXTERNAL(3);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static Type getTypeById(int type) {
            for (Type t : Type.values()) {
                if (t.getType() != type) continue;
                return t;
            }
            return null;
        }
    }
}

