/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.server.scheduledevent;

import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEvent;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventPrivacyLevel;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventType;
import org.javacord.api.entity.server.scheduledevent.internal.ServerScheduledEventBuilderDelegate;
import org.javacord.api.util.internal.DelegateFactory;

public class ServerScheduledEventBuilder {
    private final ServerScheduledEventBuilderDelegate delegate;

    public ServerScheduledEventBuilder(Server server) {
        this.delegate = DelegateFactory.createServerScheduledEventBuilderDelegate(server);
    }

    public ServerScheduledEventBuilder setAuditLogReason(String reason) {
        this.delegate.setAuditLogReason(reason);
        return this;
    }

    public ServerScheduledEventBuilder setName(String name) {
        this.delegate.setName(name);
        return this;
    }

    public ServerScheduledEventBuilder setDescription(String description) {
        this.delegate.setDescription(description);
        return this;
    }

    public ServerScheduledEventBuilder setScheduledStartTime(Instant scheduledStartTime) {
        this.delegate.setScheduledStartTime(scheduledStartTime);
        return this;
    }

    public ServerScheduledEventBuilder setScheduledEndTime(Instant scheduledEndTime) {
        this.delegate.setScheduledEndTime(scheduledEndTime);
        return this;
    }

    public ServerScheduledEventBuilder setScheduledStartAndEndTime(Instant scheduledStartTime, Duration duration) {
        return this.setScheduledStartTime(scheduledStartTime).setScheduledEndTime(scheduledStartTime.plus(duration));
    }

    public ServerScheduledEventBuilder setPrivacyLevel(ServerScheduledEventPrivacyLevel serverScheduledEventPrivacyLevel) {
        this.delegate.setPrivacyLevel(serverScheduledEventPrivacyLevel);
        return this;
    }

    public ServerScheduledEventBuilder setChannel(ServerVoiceChannel channel) {
        this.delegate.setChannelId(channel.getId());
        return this;
    }

    public ServerScheduledEventBuilder setChannelId(Long channelId) {
        this.delegate.setChannelId(channelId);
        return this;
    }

    public ServerScheduledEventBuilder setEntityType(ServerScheduledEventType serverScheduledEventType) {
        this.delegate.setEntityType(serverScheduledEventType);
        return this;
    }

    public ServerScheduledEventBuilder setEntityMetadataLocation(String entityMetadataLocation) {
        this.delegate.setEntityMetadataLocation(entityMetadataLocation);
        return this;
    }

    public ServerScheduledEventBuilder setImage(File image) {
        this.delegate.setImage(image);
        return this;
    }

    public CompletableFuture<ServerScheduledEvent> create() {
        return this.delegate.create();
    }
}

