/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.server.scheduledevent;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEvent;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventPrivacyLevel;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventStatus;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventType;
import org.javacord.api.entity.server.scheduledevent.internal.ServerScheduledEventUpdaterDelegate;
import org.javacord.api.util.internal.DelegateFactory;

public class ServerScheduledEventUpdater {
    private final ServerScheduledEventUpdaterDelegate delegate;

    public ServerScheduledEventUpdater(ServerScheduledEvent scheduledEvent) {
        this.delegate = DelegateFactory.createServerScheduledEventUpdaterDelegate(scheduledEvent);
    }

    public ServerScheduledEventUpdater setAuditLogReason(String reason) {
        this.delegate.setAuditLogReason(reason);
        return this;
    }

    public ServerScheduledEventUpdater setName(String name) {
        this.delegate.setName(name);
        return this;
    }

    public ServerScheduledEventUpdater setDescription(String description) {
        this.delegate.setDescription(description);
        return this;
    }

    public ServerScheduledEventUpdater setScheduledStartTime(Instant scheduledStartTime) {
        this.delegate.setScheduledStartTime(scheduledStartTime);
        return this;
    }

    public ServerScheduledEventUpdater setScheduledEndTime(Instant scheduledEndTime) {
        this.delegate.setScheduledEndTime(scheduledEndTime);
        return this;
    }

    public ServerScheduledEventUpdater setScheduledStartAndEndTime(Instant scheduledStartTime, Duration duration) {
        return this.setScheduledStartTime(scheduledStartTime).setScheduledEndTime(scheduledStartTime.plus(duration));
    }

    public ServerScheduledEventUpdater setPrivacyLevel(ServerScheduledEventPrivacyLevel serverScheduledEventPrivacyLevel) {
        this.delegate.setPrivacyLevel(serverScheduledEventPrivacyLevel);
        return this;
    }

    public ServerScheduledEventUpdater setChannel(ServerVoiceChannel channel) {
        this.delegate.setChannelId(channel.getId());
        return this;
    }

    public ServerScheduledEventUpdater setChannelId(Long channelId) {
        this.delegate.setChannelId(channelId);
        return this;
    }

    public ServerScheduledEventUpdater setEntityType(ServerScheduledEventType serverScheduledEventType) {
        this.delegate.setEntityType(serverScheduledEventType);
        return this;
    }

    public ServerScheduledEventUpdater setEntityMetadataLocation(String entityMetadataLocation) {
        this.delegate.setEntityMetadataLocation(entityMetadataLocation);
        return this;
    }

    public ServerScheduledEventUpdater setImage(String image) {
        this.delegate.setImage(image);
        return this;
    }

    public ServerScheduledEventUpdater setEventStatus(ServerScheduledEventStatus serverScheduledEventStatus) {
        this.delegate.setEventStatus(serverScheduledEventStatus);
        return this;
    }

    public CompletableFuture<Void> update() {
        return this.delegate.update();
    }
}

