/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.channel;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.server.ArchivedThreads;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.channel.TextableRegularServerChannelImpl;
import org.javacord.core.entity.server.ArchivedThreadsImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.listener.channel.server.text.InternalServerTextChannelAttachableListenerManager;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class ServerTextChannelImpl
extends TextableRegularServerChannelImpl
implements ServerTextChannel,
InternalServerTextChannelAttachableListenerManager {
    private volatile String topic;
    private volatile int defaultAutoArchiveDuration;

    public ServerTextChannelImpl(DiscordApiImpl api, ServerImpl server, JsonNode data) {
        super(api, server, data);
        this.topic = data.has("topic") && !data.get("topic").isNull() ? data.get("topic").asText() : "";
        this.defaultAutoArchiveDuration = data.has("default_auto_archive_duration") ? data.get("default_auto_archive_duration").asInt() : 1440;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public CompletableFuture<ArchivedThreads> getPublicArchivedThreads(Instant before, Integer limit) {
        RestRequest<ArchivedThreads> request = new RestRequest(this.getApi(), RestMethod.GET, RestEndpoint.LIST_PUBLIC_ARCHIVED_THREADS).setUrlParameters(this.getIdAsString());
        if (before != null) {
            request.addQueryParameter("before", DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC)).format(before));
        }
        if (limit != null) {
            request.addQueryParameter("limit", limit.toString());
        }
        return request.execute(result -> new ArchivedThreadsImpl((DiscordApiImpl)this.getApi(), (ServerImpl)this.getServer(), result.getJsonBody()));
    }

    @Override
    public CompletableFuture<ArchivedThreads> getPrivateArchivedThreads(Instant before, Integer limit) {
        RestRequest<ArchivedThreads> request = new RestRequest(this.getApi(), RestMethod.GET, RestEndpoint.LIST_PRIVATE_ARCHIVED_THREADS).setUrlParameters(this.getIdAsString());
        if (before != null) {
            request.addQueryParameter("before", DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC)).format(before));
        }
        if (limit != null) {
            request.addQueryParameter("limit", limit.toString());
        }
        return request.execute(result -> new ArchivedThreadsImpl((DiscordApiImpl)this.getApi(), (ServerImpl)this.getServer(), result.getJsonBody()));
    }

    @Override
    public CompletableFuture<ArchivedThreads> getJoinedPrivateArchivedThreads(Long before, Integer limit) {
        RestRequest<ArchivedThreads> request = new RestRequest(this.getApi(), RestMethod.GET, RestEndpoint.LIST_JOINED_PRIVATE_ARCHIVED_THREADS).setUrlParameters(this.getIdAsString());
        if (before != null) {
            request.addQueryParameter("before", before.toString());
        }
        if (limit != null) {
            request.addQueryParameter("limit", limit.toString());
        }
        return request.execute(result -> new ArchivedThreadsImpl((DiscordApiImpl)this.getApi(), (ServerImpl)this.getServer(), result.getJsonBody()));
    }

    public void setDefaultAutoArchiveDuration(int defaultAutoArchiveDuration) {
        this.defaultAutoArchiveDuration = defaultAutoArchiveDuration;
    }

    @Override
    public int getDefaultAutoArchiveDuration() {
        return this.defaultAutoArchiveDuration;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Override
    public String toString() {
        return String.format("ServerTextChannel (id: %s, name: %s)", this.getIdAsString(), this.getName());
    }
}

