/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.channel;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.javacord.api.audio.AudioConnection;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.user.User;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.audio.AudioConnectionImpl;
import org.javacord.core.entity.channel.TextableRegularServerChannelImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.listener.channel.server.voice.InternalServerVoiceChannelAttachableListenerManager;

public class ServerVoiceChannelImpl
extends TextableRegularServerChannelImpl
implements ServerVoiceChannel,
InternalServerVoiceChannelAttachableListenerManager {
    private volatile int bitrate;
    private volatile int userLimit;
    private final Set<Long> connectedUsers = new HashSet<Long>();

    public ServerVoiceChannelImpl(DiscordApiImpl api, ServerImpl server, JsonNode data) {
        super(api, server, data);
        this.bitrate = data.get("bitrate").asInt();
        this.userLimit = data.get("user_limit").asInt();
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public void setUserLimit(int userLimit) {
        this.userLimit = userLimit;
    }

    public void addConnectedUser(long userId) {
        this.connectedUsers.add(userId);
    }

    public void removeConnectedUser(long userId) {
        this.connectedUsers.remove(userId);
    }

    @Override
    public CompletableFuture<AudioConnection> connect(boolean muted, boolean deafened) {
        return ((CompletableFuture)this.getServer().getAudioConnection().map(AudioConnection::close).orElseGet(() -> CompletableFuture.completedFuture(null)).thenCompose(closedAudioConnection -> {
            CompletableFuture<AudioConnection> future = new CompletableFuture<AudioConnection>();
            AudioConnectionImpl connection = new AudioConnectionImpl(this, future, muted, deafened);
            ((ServerImpl)this.getServer()).setPendingAudioConnection(connection);
            return future;
        })).thenApply(conn -> {
            ((ServerImpl)this.getServer()).setAudioConnection((AudioConnectionImpl)conn);
            return conn;
        });
    }

    @Override
    public int getBitrate() {
        return this.bitrate;
    }

    @Override
    public Optional<Integer> getUserLimit() {
        return this.userLimit == 0 ? Optional.empty() : Optional.of(this.userLimit);
    }

    @Override
    public Set<Long> getConnectedUserIds() {
        return Collections.unmodifiableSet(this.connectedUsers);
    }

    @Override
    public Set<User> getConnectedUsers() {
        return Collections.unmodifiableSet(this.connectedUsers.stream().map(this.getApi()::getCachedUserById).map(optionalUser -> (User)optionalUser.orElseThrow(AssertionError::new)).collect(Collectors.toSet()));
    }

    @Override
    public boolean isConnected(long userId) {
        return this.connectedUsers.contains(userId);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Override
    public String toString() {
        return String.format("ServerVoiceChannel (id: %s, name: %s)", this.getIdAsString(), this.getName());
    }
}

