/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.channel;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.TextableRegularServerChannel;
import org.javacord.api.util.cache.MessageCache;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.channel.InternalTextChannel;
import org.javacord.core.entity.channel.RegularServerChannelImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.listener.channel.server.textable.InternalTextableRegularServerChannelAttachableListenerManager;
import org.javacord.core.util.Cleanupable;
import org.javacord.core.util.cache.MessageCacheImpl;

public class TextableRegularServerChannelImpl
extends RegularServerChannelImpl
implements TextableRegularServerChannel,
InternalTextChannel,
Cleanupable,
InternalTextableRegularServerChannelAttachableListenerManager {
    private final MessageCacheImpl messageCache;
    private volatile int delay;
    private volatile boolean nsfw;
    private volatile long parentId;

    public TextableRegularServerChannelImpl(DiscordApiImpl api, ServerImpl server, JsonNode data) {
        super(api, server, data);
        this.nsfw = data.has("nsfw") && data.get("nsfw").asBoolean();
        this.delay = data.has("rate_limit_per_user") ? data.get("rate_limit_per_user").asInt(0) : 0;
        this.parentId = Long.parseLong(data.has("parent_id") ? data.get("parent_id").asText("-1") : "-1");
        this.messageCache = new MessageCacheImpl(api, api.getDefaultMessageCacheCapacity(), api.getDefaultMessageCacheStorageTimeInSeconds(), api.isDefaultAutomaticMessageCacheCleanupEnabled());
    }

    @Override
    public boolean isNsfw() {
        return this.nsfw;
    }

    @Override
    public MessageCache getMessageCache() {
        return this.messageCache;
    }

    @Override
    public Optional<ChannelCategory> getCategory() {
        return this.getServer().getChannelCategoryById(this.parentId);
    }

    public void setNsfw(boolean nsfw) {
        this.nsfw = nsfw;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public void setSlowmodeDelayInSeconds(int delay) {
        this.delay = delay;
    }

    @Override
    public int getSlowmodeDelayInSeconds() {
        return this.delay;
    }

    @Override
    public void cleanup() {
        this.messageCache.cleanup();
    }
}

