/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.channel;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.TextableRegularServerChannel;
import org.javacord.api.entity.channel.internal.TextableRegularServerChannelUpdaterDelegate;
import org.javacord.core.entity.channel.RegularServerChannelUpdaterDelegateImpl;

public class TextableRegularServerChannelUpdaterDelegateImpl
extends RegularServerChannelUpdaterDelegateImpl
implements TextableRegularServerChannelUpdaterDelegate {
    protected final TextableRegularServerChannel channel;
    protected Boolean nsfw = null;
    protected ChannelCategory category = null;
    protected boolean modifyCategory = false;
    protected int delay = 0;
    protected boolean modifyDelay = false;

    public TextableRegularServerChannelUpdaterDelegateImpl(TextableRegularServerChannel channel) {
        super(channel);
        this.channel = channel;
    }

    @Override
    public void setNsfw(boolean nsfw) {
        this.nsfw = nsfw;
    }

    @Override
    public void setCategory(ChannelCategory category) {
        this.category = category;
        this.modifyCategory = true;
    }

    @Override
    public void removeCategory() {
        this.setCategory(null);
    }

    @Override
    public void setSlowmodeDelayInSeconds(int delay) {
        this.delay = delay;
        this.modifyDelay = true;
    }

    @Override
    protected boolean prepareUpdateBody(ObjectNode body) {
        boolean patchChannel = super.prepareUpdateBody(body);
        if (this.nsfw != null) {
            body.put("nsfw", (boolean)this.nsfw);
            patchChannel = true;
        }
        if (this.modifyCategory) {
            body.put("parent_id", this.category == null ? null : this.category.getIdAsString());
            patchChannel = true;
        }
        if (this.modifyDelay) {
            body.put("rate_limit_per_user", this.delay);
            patchChannel = true;
        }
        return patchChannel;
    }
}

