/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.server.scheduledevent;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEvent;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventPrivacyLevel;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventType;
import org.javacord.api.entity.server.scheduledevent.internal.ServerScheduledEventBuilderDelegate;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.entity.server.scheduledevent.ServerScheduledEventImpl;
import org.javacord.core.util.io.FileUtils;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class ServerScheduledEventBuilderDelegateImpl
implements ServerScheduledEventBuilderDelegate {
    private final ServerImpl server;
    private String reason = null;
    private String name = null;
    private String description = null;
    private Instant scheduledStartTime = null;
    private Instant scheduledEndTime = null;
    private ServerScheduledEventPrivacyLevel serverScheduledEventPrivacyLevel = null;
    private Long channelId = null;
    private ServerScheduledEventType serverScheduledEventType = null;
    private String entityMetadataLocation = null;
    private File image = null;

    public ServerScheduledEventBuilderDelegateImpl(ServerImpl server) {
        this.server = server;
    }

    @Override
    public void setAuditLogReason(String reason) {
        this.reason = reason;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setScheduledStartTime(Instant scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    @Override
    public void setScheduledEndTime(Instant scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    @Override
    public void setPrivacyLevel(ServerScheduledEventPrivacyLevel serverScheduledEventPrivacyLevel) {
        this.serverScheduledEventPrivacyLevel = serverScheduledEventPrivacyLevel;
    }

    @Override
    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    @Override
    public void setEntityType(ServerScheduledEventType serverScheduledEventType) {
        this.serverScheduledEventType = serverScheduledEventType;
    }

    @Override
    public void setEntityMetadataLocation(String entityMetadataLocation) {
        this.entityMetadataLocation = entityMetadataLocation;
    }

    @Override
    public void setImage(File image) {
        this.image = image;
    }

    @Override
    public CompletableFuture<ServerScheduledEvent> create() {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (this.name != null) {
            body.put("name", this.name);
        }
        if (this.description != null) {
            body.put("description", this.description);
        }
        if (this.scheduledStartTime != null) {
            body.put("scheduled_start_time", this.scheduledStartTime.toString());
        }
        if (this.scheduledEndTime != null) {
            body.put("scheduled_end_time", this.scheduledEndTime.toString());
        }
        if (this.serverScheduledEventPrivacyLevel != null) {
            body.put("privacy_level", this.serverScheduledEventPrivacyLevel.getValue());
        }
        if (this.channelId != null) {
            body.put("channel_id", this.channelId);
        }
        if (this.serverScheduledEventType != null) {
            body.put("entity_type", this.serverScheduledEventType.getValue());
        }
        if (this.entityMetadataLocation != null) {
            ObjectNode node = body.putObject("entity_metadata");
            node.put("location", this.entityMetadataLocation);
        }
        if (this.image != null) {
            try {
                String dataUri = FileUtils.convertFileToDataUri(this.image);
                body.put("image", dataUri);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new RestRequest(this.server.getApi(), RestMethod.POST, RestEndpoint.SCHEDULED_EVENTS).setUrlParameters(this.server.getIdAsString()).setBody(body).setAuditLogReason(this.reason).execute(result -> new ServerScheduledEventImpl((DiscordApiImpl)this.server.getApi(), result.getJsonBody()));
    }
}

