/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.server.scheduledevent;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEvent;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventMetadata;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventPrivacyLevel;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventStatus;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventType;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventUser;
import org.javacord.api.entity.user.User;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.IconImpl;
import org.javacord.core.entity.server.scheduledevent.ServerScheduledEventMetadataImpl;
import org.javacord.core.entity.server.scheduledevent.ServerScheduledEventUserImpl;
import org.javacord.core.entity.user.MemberImpl;
import org.javacord.core.entity.user.UserImpl;
import org.javacord.core.util.logging.LoggerUtil;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class ServerScheduledEventImpl
implements ServerScheduledEvent {
    private static final Logger logger = LoggerUtil.getLogger(ServerScheduledEventImpl.class);
    private final DiscordApi api;
    private final long id;
    private final long serverId;
    private final Long channelId;
    private final Long creatorId;
    private final String name;
    private final String description;
    private final ServerScheduledEventType serverScheduledEventType;
    private final Long entityId;
    private final ServerScheduledEventStatus status;
    private final ServerScheduledEventPrivacyLevel serverScheduledEventPrivacyLevel;
    private final Instant scheduledStartTime;
    private final Instant scheduledEndTime;
    private final Integer userCount;
    private final ServerScheduledEventMetadata serverScheduledEventMetadata;
    private final String image;
    private final User creator;

    public ServerScheduledEventImpl(DiscordApiImpl api, JsonNode data) {
        this.api = api;
        this.id = data.get("id").asLong();
        this.serverId = data.get("guild_id").asLong();
        this.channelId = data.path("channel_id").longValue();
        this.creatorId = data.path("creator_id").longValue();
        this.name = data.get("name").asText();
        this.description = data.path("description").textValue();
        this.serverScheduledEventType = ServerScheduledEventType.fromValue(data.get("entity_type").asInt());
        this.entityId = data.path("entity_id").longValue();
        this.status = ServerScheduledEventStatus.fromValue(data.get("status").asInt());
        this.serverScheduledEventPrivacyLevel = ServerScheduledEventPrivacyLevel.fromValue(data.get("privacy_level").asInt());
        this.scheduledStartTime = OffsetDateTime.parse(data.get("scheduled_start_time").asText()).toInstant();
        this.scheduledEndTime = data.hasNonNull("scheduled_end_time") ? OffsetDateTime.parse(data.get("scheduled_end_time").asText()).toInstant() : null;
        this.serverScheduledEventMetadata = data.hasNonNull("entity_metadata") ? new ServerScheduledEventMetadataImpl(data.get("entity_metadata")) : null;
        this.creator = data.hasNonNull("creator") ? new UserImpl(api, data.get("creator"), (MemberImpl)null, null) : null;
        this.image = data.path("image").textValue();
        this.userCount = data.path("user_count").intValue();
    }

    @Override
    public DiscordApi getApi() {
        return this.api;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public long getServerId() {
        return this.serverId;
    }

    @Override
    public Optional<Long> getChannelId() {
        return Optional.ofNullable(this.channelId);
    }

    @Override
    public Optional<Long> getCreatorId() {
        return Optional.ofNullable(this.creatorId);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public Instant getStartTime() {
        return this.scheduledStartTime;
    }

    @Override
    public Optional<Instant> getEndTime() {
        return Optional.ofNullable(this.scheduledEndTime);
    }

    @Override
    public ServerScheduledEventPrivacyLevel getPrivacyLevel() {
        return this.serverScheduledEventPrivacyLevel;
    }

    @Override
    public ServerScheduledEventStatus getStatus() {
        return this.status;
    }

    @Override
    public ServerScheduledEventType getEntityType() {
        return this.serverScheduledEventType;
    }

    @Override
    public Optional<Long> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    @Override
    public Optional<ServerScheduledEventMetadata> getEntityMetadata() {
        return Optional.ofNullable(this.serverScheduledEventMetadata);
    }

    @Override
    public Optional<User> getCreator() {
        return Optional.ofNullable(this.creator);
    }

    @Override
    public Optional<Integer> getUserCount() {
        return Optional.ofNullable(this.userCount);
    }

    @Override
    public Optional<Icon> getImage() {
        if (null == this.image) {
            return Optional.empty();
        }
        try {
            StringBuilder builder = new StringBuilder().append("https://").append("cdn.discordapp.com").append("/guild-events/").append(this.getId()).append("/").append(this.image).append(".png");
            return Optional.of(new IconImpl(this.getApi(), new URL(builder.toString())));
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the icon is malformed! Please contact the developer!", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public CompletableFuture<Void> delete() {
        return new RestRequest(this.getApi(), RestMethod.DELETE, RestEndpoint.SCHEDULED_EVENTS).setUrlParameters(this.getIdAsString()).setUrlParameters(this.getIdAsString()).execute(result -> null);
    }

    @Override
    public CompletableFuture<Set<ServerScheduledEventUser>> requestParticipants() {
        CompletableFuture<Set<ServerScheduledEventUser>> future = new CompletableFuture<Set<ServerScheduledEventUser>>();
        ArrayList<ServerScheduledEventUser> users = new ArrayList<ServerScheduledEventUser>();
        this.fetchParticipantsPageAndAddAllToCollection(null, users, future);
        return future;
    }

    @Override
    public CompletableFuture<Set<ServerScheduledEventUser>> requestParticipants(Integer limit, Long before, Long after) {
        return new RestRequest(this.getApi(), RestMethod.GET, RestEndpoint.SCHEDULED_EVENT_USERS).setUrlParameters(String.valueOf(this.getServerId()), this.getIdAsString()).addQueryParameter("limit", String.valueOf(limit)).addQueryParameter("after", after != null ? String.valueOf(after) : null).addQueryParameter("before", before != null ? String.valueOf(before) : null).addQueryParameter("with_member", String.valueOf(true)).execute(result -> {
            HashSet<ServerScheduledEventUserImpl> users = new HashSet<ServerScheduledEventUserImpl>();
            for (JsonNode jsonNode : result.getJsonBody()) {
                users.add(new ServerScheduledEventUserImpl(this, jsonNode));
            }
            return users;
        });
    }

    private void fetchParticipantsPageAndAddAllToCollection(Long after, ArrayList<ServerScheduledEventUser> userList, CompletableFuture<Set<ServerScheduledEventUser>> futureToComplete) {
        ((CompletableFuture)this.requestParticipants(null, null, after).thenAccept(page -> {
            userList.addAll((Collection<ServerScheduledEventUser>)page);
            if (page.size() < 100) {
                futureToComplete.complete(Collections.unmodifiableSet(new HashSet(userList)));
                return;
            }
            this.fetchParticipantsPageAndAddAllToCollection(((ServerScheduledEventUser)userList.get(userList.size() - 1)).getUser().getId(), userList, futureToComplete);
        })).exceptionally(t -> {
            futureToComplete.completeExceptionally((Throwable)t);
            return null;
        });
    }
}

