/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.server.scheduledevent;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEvent;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventPrivacyLevel;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventStatus;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEventType;
import org.javacord.api.entity.server.scheduledevent.internal.ServerScheduledEventUpdaterDelegate;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class ServerScheduledEventUpdaterDelegateImpl
implements ServerScheduledEventUpdaterDelegate {
    private final ServerScheduledEvent scheduledEvent;
    private String reason = null;
    private String name = null;
    private String description = null;
    private boolean patchDescription = false;
    private Instant scheduledStartTime = null;
    private Instant scheduledEndTime = null;
    private ServerScheduledEventPrivacyLevel serverScheduledEventPrivacyLevel = null;
    private Long channelId = null;
    private boolean patchChannelId = false;
    private ServerScheduledEventType serverScheduledEventType = null;
    private String entityMetadataLocation = null;
    private boolean patchEntityMetadataLocation = false;
    private String image = null;
    private ServerScheduledEventStatus serverScheduledEventStatus = null;

    public ServerScheduledEventUpdaterDelegateImpl(ServerScheduledEvent scheduledEvent) {
        this.scheduledEvent = scheduledEvent;
    }

    @Override
    public void setAuditLogReason(String reason) {
        this.reason = reason;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.patchDescription = true;
    }

    @Override
    public void setScheduledStartTime(Instant scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    @Override
    public void setScheduledEndTime(Instant scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    @Override
    public void setPrivacyLevel(ServerScheduledEventPrivacyLevel serverScheduledEventPrivacyLevel) {
        this.serverScheduledEventPrivacyLevel = serverScheduledEventPrivacyLevel;
    }

    @Override
    public void setChannelId(Long channelId) {
        this.channelId = channelId;
        this.patchChannelId = true;
    }

    @Override
    public void setEntityType(ServerScheduledEventType serverScheduledEventType) {
        this.serverScheduledEventType = serverScheduledEventType;
    }

    @Override
    public void setEntityMetadataLocation(String entityMetadataLocation) {
        this.entityMetadataLocation = entityMetadataLocation;
        this.patchEntityMetadataLocation = true;
    }

    @Override
    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public void setEventStatus(ServerScheduledEventStatus serverScheduledEventStatus) {
        this.serverScheduledEventStatus = serverScheduledEventStatus;
    }

    @Override
    public CompletableFuture<Void> update() {
        boolean patchScheduledEvent = false;
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (null != this.description) {
            body.put("description", this.description);
            patchScheduledEvent = true;
        }
        if (null == this.description && this.patchDescription) {
            body.putNull("description");
            patchScheduledEvent = true;
        }
        if (null != this.scheduledStartTime) {
            body.put("scheduled_start_time", this.scheduledStartTime.toString());
            patchScheduledEvent = true;
        }
        if (null != this.scheduledEndTime) {
            body.put("scheduled_end_time", this.scheduledEndTime.toString());
            patchScheduledEvent = true;
        }
        if (null != this.serverScheduledEventPrivacyLevel) {
            body.put("privacy_level", this.serverScheduledEventPrivacyLevel.getValue());
            patchScheduledEvent = true;
        }
        if (null != this.channelId) {
            body.put("channel_id", this.channelId);
            patchScheduledEvent = true;
        }
        if (null == this.channelId && this.patchChannelId) {
            body.putNull("channel_id");
            patchScheduledEvent = true;
        }
        if (null != this.serverScheduledEventType) {
            body.put("entity_type", this.serverScheduledEventType.getValue());
            patchScheduledEvent = true;
        }
        if (null != this.entityMetadataLocation) {
            ObjectNode node = body.putObject("entity_metadata");
            node.put("location", this.entityMetadataLocation);
            patchScheduledEvent = true;
        }
        if (null == this.entityMetadataLocation && this.patchEntityMetadataLocation) {
            body.putNull("entity_metadata");
            patchScheduledEvent = true;
        }
        if (null != this.image) {
            body.put("image", this.image);
            patchScheduledEvent = true;
        }
        if (null != this.serverScheduledEventStatus) {
            body.put("status", this.serverScheduledEventStatus.getValue());
            patchScheduledEvent = true;
        }
        if (patchScheduledEvent) {
            return new RestRequest(this.scheduledEvent.getApi(), RestMethod.PATCH, RestEndpoint.SCHEDULED_EVENTS).setUrlParameters(this.scheduledEvent.getServer().getIdAsString(), this.scheduledEvent.getIdAsString()).setBody(body).setAuditLogReason(this.reason).execute(result -> null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

