/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.guild.scheduledevent;

import com.fasterxml.jackson.databind.JsonNode;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.server.Server;
import org.javacord.api.event.server.scheduledevent.ServerScheduledEventDeleteEvent;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.entity.server.scheduledevent.ServerScheduledEventImpl;
import org.javacord.core.event.server.scheduledevent.ServerScheduledEventDeleteEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;

public class GuildScheduledEventDeleteHandler
extends PacketHandler {
    public GuildScheduledEventDeleteHandler(DiscordApi api) {
        super(api, true, "GUILD_SCHEDULED_EVENT_DELETE");
    }

    @Override
    public void handle(JsonNode packet) {
        long serverId = Long.parseLong(packet.get("guild_id").asText());
        this.api.getPossiblyUnreadyServerById(serverId).ifPresent(server -> {
            ServerImpl serverImpl = (ServerImpl)server;
            ServerScheduledEventImpl scheduledEvent = new ServerScheduledEventImpl(this.api, packet);
            serverImpl.removeScheduledEvent(scheduledEvent.getId());
            ServerScheduledEventDeleteEventImpl event = new ServerScheduledEventDeleteEventImpl((Server)server, scheduledEvent);
            this.api.getEventDispatcher().dispatchServerScheduledEventDeleteEvent((DispatchQueueSelector)((Object)server), (Server)server, (ServerScheduledEventDeleteEvent)event);
        });
    }
}

