/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.guild.scheduledevent;

import com.fasterxml.jackson.databind.JsonNode;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.server.scheduledevent.ServerScheduledEvent;
import org.javacord.api.event.server.scheduledevent.ServerScheduledEventUpdateEvent;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.entity.server.scheduledevent.ServerScheduledEventImpl;
import org.javacord.core.event.server.scheduledevent.ServerScheduledEventUpdateEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;

public class GuildScheduledEventUpdateHandler
extends PacketHandler {
    public GuildScheduledEventUpdateHandler(DiscordApi api) {
        super(api, true, "GUILD_SCHEDULED_EVENT_UPDATE");
    }

    @Override
    public void handle(JsonNode packet) {
        long serverId = Long.parseLong(packet.get("guild_id").asText());
        this.api.getPossiblyUnreadyServerById(serverId).ifPresent(server -> {
            ServerImpl serverImpl = (ServerImpl)server;
            ServerScheduledEventImpl scheduledEvent = new ServerScheduledEventImpl(this.api, packet);
            ServerScheduledEvent oldScheduledEvent = serverImpl.getScheduledEventById(scheduledEvent.getId()).orElseThrow(AssertionError::new);
            serverImpl.removeScheduledEvent(scheduledEvent.getId());
            serverImpl.addScheduledEvent(scheduledEvent);
            ServerScheduledEventUpdateEventImpl event = new ServerScheduledEventUpdateEventImpl((Server)server, oldScheduledEvent, scheduledEvent);
            this.api.getEventDispatcher().dispatchServerScheduledEventUpdateEvent((DispatchQueueSelector)((Object)server), (Server)server, (ServerScheduledEventUpdateEvent)event);
        });
    }
}

